/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.web;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.moskito.core.calltrace.CurrentlyTracedCall;
import net.anotheria.moskito.core.calltrace.RunningTraceContainer;
import net.anotheria.moskito.core.calltrace.TraceStep;
import net.anotheria.moskito.core.calltrace.TracedCall;
import net.anotheria.moskito.core.predefined.ActionStats;
import net.anotheria.moskito.core.predefined.Constants;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.registry.ProducerRegistryFactory;
import net.anotheria.moskito.core.stats.Interval;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public abstract class MoskitoAction
extends Action
implements IStatsProducer {
    private volatile ActionStats stats = new ActionStats("execute", this.getMonitoringIntervals());
    private List<IStats> statsList = new ArrayList<IStats>(1);

    protected MoskitoAction() {
        this.statsList.add((IStats)this.stats);
        ProducerRegistryFactory.getProducerRegistryInstance().registerProducer((IStatsProducer)this);
    }

    public final ActionForward execute(ActionMapping mapping, ActionForm bean, HttpServletRequest req, HttpServletResponse res) throws Exception {
        CurrentlyTracedCall tracedCall;
        this.stats.addRequest();
        long startTime = System.nanoTime();
        TracedCall aTracedCall = RunningTraceContainer.getCurrentlyTracedCall();
        TraceStep currentStep = null;
        CurrentlyTracedCall currentlyTracedCall = tracedCall = aTracedCall.callTraced() ? (CurrentlyTracedCall)aTracedCall : null;
        if (tracedCall != null) {
            currentStep = tracedCall.startStep(this.getProducerId() + '.' + "execute", (IStatsProducer)this);
        }
        try {
            this.preProcessExecute(mapping, bean, req, res);
            ActionForward forward = this.moskitoExecute(mapping, bean, req, res);
            this.postProcessExecute(mapping, bean, req, res);
            ActionForward actionForward = forward;
            return actionForward;
        }
        catch (Exception e) {
            this.stats.notifyError((Throwable)e);
            throw e;
        }
        finally {
            long duration = System.nanoTime() - startTime;
            this.stats.addExecutionTime(duration);
            this.stats.notifyRequestFinished();
            if (currentStep != null) {
                currentStep.setDuration(duration);
            }
            if (tracedCall != null) {
                tracedCall.endStep();
            }
        }
    }

    protected void preProcessExecute(ActionMapping mapping, ActionForm af, HttpServletRequest req, HttpServletResponse res) throws Exception {
    }

    protected void postProcessExecute(ActionMapping mapping, ActionForm af, HttpServletRequest req, HttpServletResponse res) throws Exception {
    }

    public abstract ActionForward moskitoExecute(ActionMapping var1, ActionForm var2, HttpServletRequest var3, HttpServletResponse var4) throws Exception;

    protected Interval[] getMonitoringIntervals() {
        return Constants.getDefaultIntervals();
    }

    public String getCategory() {
        return "action";
    }

    public String getSubsystem() {
        return "default";
    }

    public String getProducerId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public List<IStats> getStats() {
        return this.statsList;
    }
}

