/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.moskito.core.calltrace.CurrentlyTracedCall;
import net.anotheria.moskito.core.calltrace.RunningTraceContainer;
import net.anotheria.moskito.core.calltrace.TraceStep;
import net.anotheria.moskito.core.calltrace.TracedCall;
import net.anotheria.moskito.core.predefined.Constants;
import net.anotheria.moskito.core.predefined.ServletStats;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.registry.ProducerRegistryFactory;
import net.anotheria.moskito.core.stats.Interval;

public class MoskitoHttpServlet
extends HttpServlet
implements IStatsProducer {
    private static final long serialVersionUID = -105379295937733815L;
    private transient ServletStats deleteStats;
    private transient ServletStats getStats;
    private transient ServletStats headStats;
    private transient ServletStats optionsStats;
    private transient ServletStats postStats;
    private transient ServletStats putStats;
    private transient ServletStats traceStats;
    private transient ServletStats lastModifiedStats;
    private transient List<IStats> cachedStatList;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.getStats = new ServletStats("get", this.getMonitoringIntervals());
        this.postStats = new ServletStats("post", this.getMonitoringIntervals());
        this.putStats = new ServletStats("put", this.getMonitoringIntervals());
        this.headStats = new ServletStats("head", this.getMonitoringIntervals());
        this.optionsStats = new ServletStats("options", this.getMonitoringIntervals());
        this.traceStats = new ServletStats("trace", this.getMonitoringIntervals());
        this.deleteStats = new ServletStats("delete", this.getMonitoringIntervals());
        this.lastModifiedStats = new ServletStats("lastModified", this.getMonitoringIntervals());
        this.cachedStatList = new ArrayList<IStats>(this.useShortStatList() ? 2 : 8);
        this.cachedStatList.add((IStats)this.getStats);
        this.cachedStatList.add((IStats)this.postStats);
        if (!this.useShortStatList()) {
            this.cachedStatList.add((IStats)this.deleteStats);
            this.cachedStatList.add((IStats)this.headStats);
            this.cachedStatList.add((IStats)this.optionsStats);
            this.cachedStatList.add((IStats)this.putStats);
            this.cachedStatList.add((IStats)this.traceStats);
            this.cachedStatList.add((IStats)this.lastModifiedStats);
        }
        ProducerRegistryFactory.getProducerRegistryInstance().registerProducer((IStatsProducer)this);
    }

    protected final void doDelete(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.deleteStats.addRequest();
        try {
            long startTime = System.nanoTime();
            this.moskitoDoDelete(req, res);
            long executionTime = System.nanoTime() - startTime;
            this.deleteStats.addExecutionTime(executionTime);
        }
        catch (ServletException e) {
            this.deleteStats.notifyServletException((Throwable)e);
            throw e;
        }
        catch (IOException e) {
            this.deleteStats.notifyIOException((Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            this.deleteStats.notifyRuntimeException((Throwable)e);
            throw e;
        }
        catch (Error e) {
            this.deleteStats.notifyError((Throwable)e);
            throw e;
        }
        finally {
            this.deleteStats.notifyRequestFinished();
        }
    }

    protected final void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        CurrentlyTracedCall runningUseCase;
        this.getStats.addRequest();
        TracedCall aRunningUseCase = RunningTraceContainer.getCurrentlyTracedCall();
        TraceStep currentElement = null;
        CurrentlyTracedCall currentlyTracedCall = runningUseCase = aRunningUseCase.callTraced() ? (CurrentlyTracedCall)aRunningUseCase : null;
        if (runningUseCase != null) {
            currentElement = runningUseCase.startStep(this.getProducerId() + '.' + "doGet", (IStatsProducer)this);
        }
        long startTime = System.nanoTime();
        try {
            this.moskitoDoGet(req, res);
        }
        catch (ServletException e) {
            this.getStats.notifyServletException((Throwable)e);
            throw e;
        }
        catch (IOException e) {
            this.getStats.notifyIOException((Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            this.getStats.notifyRuntimeException((Throwable)e);
            throw e;
        }
        catch (Error e) {
            this.getStats.notifyError((Throwable)e);
            throw e;
        }
        finally {
            this.getStats.notifyRequestFinished();
            long executionTime = System.nanoTime() - startTime;
            this.getStats.addExecutionTime(executionTime);
            if (currentElement != null) {
                currentElement.setDuration(executionTime);
            }
            if (runningUseCase != null) {
                runningUseCase.endStep();
            }
        }
    }

    protected final void doHead(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.headStats.addRequest();
        try {
            long startTime = System.nanoTime();
            this.moskitoDoHead(req, res);
            long executionTime = System.nanoTime() - startTime;
            this.headStats.addExecutionTime(executionTime);
        }
        catch (ServletException e) {
            this.headStats.notifyServletException((Throwable)e);
            throw e;
        }
        catch (IOException e) {
            this.headStats.notifyIOException((Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            this.headStats.notifyRuntimeException((Throwable)e);
            throw e;
        }
        catch (Error e) {
            this.headStats.notifyError((Throwable)e);
            throw e;
        }
        finally {
            this.headStats.notifyRequestFinished();
        }
    }

    protected final void doOptions(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.optionsStats.addRequest();
        try {
            long startTime = System.nanoTime();
            this.moskitoDoOptions(req, res);
            long executionTime = System.nanoTime() - startTime;
            this.optionsStats.addExecutionTime(executionTime);
        }
        catch (ServletException e) {
            this.optionsStats.notifyServletException((Throwable)e);
            throw e;
        }
        catch (IOException e) {
            this.optionsStats.notifyIOException((Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            this.optionsStats.notifyRuntimeException((Throwable)e);
            throw e;
        }
        catch (Error e) {
            this.optionsStats.notifyError((Throwable)e);
            throw e;
        }
        finally {
            this.optionsStats.notifyRequestFinished();
        }
    }

    protected final void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.postStats.addRequest();
        try {
            long startTime = System.nanoTime();
            this.moskitoDoPost(req, res);
            long executionTime = System.nanoTime() - startTime;
            this.postStats.addExecutionTime(executionTime);
        }
        catch (ServletException e) {
            this.postStats.notifyServletException((Throwable)e);
            throw e;
        }
        catch (IOException e) {
            this.postStats.notifyIOException((Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            this.postStats.notifyRuntimeException((Throwable)e);
            throw e;
        }
        catch (Error e) {
            this.postStats.notifyError((Throwable)e);
            throw e;
        }
        finally {
            this.postStats.notifyRequestFinished();
        }
    }

    protected final void doPut(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.putStats.addRequest();
        try {
            long startTime = System.nanoTime();
            this.moskitoDoPut(req, res);
            long executionTime = System.nanoTime() - startTime;
            this.putStats.addExecutionTime(executionTime);
        }
        catch (ServletException e) {
            this.putStats.notifyServletException((Throwable)e);
            throw e;
        }
        catch (IOException e) {
            this.putStats.notifyIOException((Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            this.putStats.notifyRuntimeException((Throwable)e);
            throw e;
        }
        catch (Error e) {
            this.putStats.notifyError((Throwable)e);
            throw e;
        }
        finally {
            this.putStats.notifyRequestFinished();
        }
    }

    protected final void doTrace(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.traceStats.addRequest();
        try {
            long startTime = System.nanoTime();
            this.moskitoDoTrace(req, res);
            long executionTime = System.nanoTime() - startTime;
            this.traceStats.addExecutionTime(executionTime);
        }
        catch (ServletException e) {
            this.traceStats.notifyServletException((Throwable)e);
            throw e;
        }
        catch (IOException e) {
            this.traceStats.notifyIOException((Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            this.traceStats.notifyRuntimeException((Throwable)e);
            throw e;
        }
        catch (Error e) {
            this.traceStats.notifyError((Throwable)e);
            throw e;
        }
        finally {
            this.traceStats.notifyRequestFinished();
        }
    }

    protected final long getLastModified(HttpServletRequest req) {
        this.lastModifiedStats.addRequest();
        try {
            long startTime = System.nanoTime();
            long retValue = this.moskitoGetLastModified(req);
            long executionTime = System.nanoTime() - startTime;
            this.lastModifiedStats.addExecutionTime(executionTime);
            long l = retValue;
            return l;
        }
        catch (RuntimeException e) {
            this.lastModifiedStats.notifyRuntimeException((Throwable)e);
            throw e;
        }
        catch (Error e) {
            this.lastModifiedStats.notifyError((Throwable)e);
            throw e;
        }
        finally {
            this.lastModifiedStats.notifyRequestFinished();
        }
    }

    protected void moskitoDoDelete(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        super.doDelete(req, res);
    }

    protected void moskitoDoGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        super.doGet(req, res);
    }

    protected void moskitoDoHead(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        super.doHead(req, res);
    }

    protected void moskitoDoOptions(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        super.doOptions(req, res);
    }

    protected void moskitoDoPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        super.doPost(req, res);
    }

    protected void moskitoDoPut(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        super.doPut(req, res);
    }

    protected void moskitoDoTrace(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        super.doTrace(req, res);
    }

    protected long moskitoGetLastModified(HttpServletRequest req) {
        return super.getLastModified(req);
    }

    public String getProducerId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public List<IStats> getStats() {
        return this.cachedStatList;
    }

    protected boolean useShortStatList() {
        return true;
    }

    protected Interval[] getMonitoringIntervals() {
        return Constants.getDefaultIntervals();
    }

    public String getCategory() {
        return "servlet";
    }

    public String getSubsystem() {
        return "default";
    }
}

