/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import net.anotheria.moskito.core.predefined.Constants;
import net.anotheria.moskito.core.predefined.ServletStats;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.registry.ProducerRegistryFactory;

public class ServletWrapper
implements Servlet,
IStatsProducer {
    private Servlet target;
    private static Class<Servlet> targetClass;
    private ServletStats serviceStats;
    private List<IStats> cachedStatList;
    private String producerId;

    public static void setTargetClass(Class<Servlet> aClass) {
        targetClass = aClass;
    }

    public ServletWrapper() {
        try {
            this.target = targetClass.newInstance();
            this.producerId = targetClass.getName() + "_prx";
        }
        catch (Exception e) {
            throw new RuntimeException("Can't create wrapped servlet!");
        }
    }

    public void destroy() {
        this.target.destroy();
    }

    public ServletConfig getServletConfig() {
        return this.target.getServletConfig();
    }

    public String getServletInfo() {
        return this.target.getServletInfo();
    }

    public void init(ServletConfig arg0) throws ServletException {
        this.serviceStats = new ServletStats("service", Constants.getDefaultIntervals());
        this.cachedStatList = new ArrayList<IStats>(1);
        this.cachedStatList.add((IStats)this.serviceStats);
        ProducerRegistryFactory.getProducerRegistryInstance().registerProducer((IStatsProducer)this);
        this.target.init(arg0);
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        this.serviceStats.addRequest();
        try {
            long startTime = System.nanoTime();
            this.target.service(req, res);
            long executionTime = System.nanoTime() - startTime;
            this.serviceStats.addExecutionTime(executionTime);
        }
        catch (ServletException e) {
            this.serviceStats.notifyServletException((Throwable)e);
            throw e;
        }
        catch (IOException e) {
            this.serviceStats.notifyIOException((Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            this.serviceStats.notifyRuntimeException((Throwable)e);
            throw e;
        }
        catch (Error e) {
            this.serviceStats.notifyError((Throwable)e);
            throw e;
        }
        finally {
            this.serviceStats.notifyRequestFinished();
        }
    }

    public String getCategory() {
        return "servlet";
    }

    public String getSubsystem() {
        return "default";
    }

    public String getProducerId() {
        return this.producerId;
    }

    public List<IStats> getStats() {
        return this.cachedStatList;
    }
}

