/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.web.filters;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugRequestFilter
implements Filter {
    private static Logger logger = LoggerFactory.getLogger(DebugRequestFilter.class);
    private static final String PARAM_DIAGNOSTIC_DEBUG = "mskDiagnosticsDebugRequest";
    private static final String HEADERS = "headers:";
    private static final String ATTRIBUTES = "attributes:";
    private static final String PARAMETERS = "parameters:";
    private static final String SESSION_ATTRIBUTES = "sessionAttributes:";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest req, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(req instanceof HttpServletRequest) || req.getParameter(PARAM_DIAGNOSTIC_DEBUG) == null) {
            chain.doFilter(req, response);
            return;
        }
        this.debug((HttpServletRequest)req);
        chain.doFilter(req, response);
    }

    private void debug(HttpServletRequest request) {
        if (!logger.isInfoEnabled()) {
            logger.warn("Logger INTO not enabled!");
            return;
        }
        logger.info(HEADERS);
        Enumeration headerEnumeration = request.getHeaderNames();
        while (headerEnumeration.hasMoreElements()) {
            String elementName = (String)headerEnumeration.nextElement();
            logger.info(elementName + " = " + request.getHeader(elementName));
        }
        logger.info(ATTRIBUTES);
        Enumeration attributeEnumeration = request.getAttributeNames();
        while (attributeEnumeration.hasMoreElements()) {
            String elementName = (String)attributeEnumeration.nextElement();
            logger.info(elementName + " = " + request.getAttribute(elementName));
        }
        logger.info(PARAMETERS);
        Map parameterMap = request.getParameterMap();
        for (Map.Entry entry : parameterMap.entrySet()) {
            StringBuilder parameterValues = new StringBuilder();
            if (entry.getValue() != null) {
                for (String value : (String[])entry.getValue()) {
                    parameterValues.append(value);
                    parameterValues.append(' ');
                }
            }
            logger.info((String)entry.getKey() + " = " + parameterValues);
        }
        HttpSession session = request.getSession(false);
        if (session != null) {
            logger.info("Session = " + session.getId());
            logger.info(SESSION_ATTRIBUTES);
            Enumeration sessionAttrEnumeration = session.getAttributeNames();
            while (sessionAttrEnumeration.hasMoreElements()) {
                String elementName = (String)sessionAttrEnumeration.nextElement();
                logger.info(elementName + " = " + session.getAttribute(elementName));
            }
        }
        logger.info("Remote ip = " + request.getRemoteAddr());
        logger.info("Server name = " + request.getServerName());
        logger.info("Server port = " + request.getServerPort());
    }

    public void destroy() {
    }
}

