/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.web.filters;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.anotheria.moskito.core.calltrace.CurrentlyTracedCall;
import net.anotheria.moskito.core.calltrace.RunningTraceContainer;
import net.anotheria.moskito.core.calltrace.TracedCall;
import net.anotheria.moskito.core.journey.Journey;
import net.anotheria.moskito.core.journey.JourneyManager;
import net.anotheria.moskito.core.journey.JourneyManagerFactory;
import net.anotheria.moskito.web.filters.JourneyRecord;

public class JourneyStarterFilter
implements Filter {
    public static final String HEADER_NAME = "JourneyName";
    private JourneyManager journeyManager;

    public void init(FilterConfig chain) throws ServletException {
        this.journeyManager = JourneyManagerFactory.getJourneyManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        String journeyName = null;
        String journeyNameFromHeader = req.getHeader(HEADER_NAME);
        if (journeyNameFromHeader != null) {
            journeyName = journeyNameFromHeader;
        }
        if (journeyName == null) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        Journey journey = this.journeyManager.createJourney(journeyName);
        HttpSession session = req.getSession(false);
        JourneyRecord record = new JourneyRecord(journeyName);
        if (session != null) {
            session.setAttribute("mskJourneyRecord", (Object)record);
        }
        String url = req.getServletPath();
        if (req.getPathInfo() != null) {
            url = url + req.getPathInfo();
        }
        if (req.getQueryString() != null) {
            url = url + '?' + req.getQueryString();
        }
        RunningTraceContainer.startTracedCall((String)(record.getUseCaseName() + '-' + url));
        try {
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            TracedCall last = RunningTraceContainer.endTrace();
            journey.addUseCase((CurrentlyTracedCall)last);
            RunningTraceContainer.cleanup();
        }
    }

    public void destroy() {
    }
}

