/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.description.type;

import java.util.Arrays;
import java.util.List;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.bytecode.StackSize;
import net.bytebuddy.matcher.FilterableList;
import org.objectweb.asm.Type;

public interface TypeList
extends FilterableList<TypeDescription, TypeList> {
    public String[] toInternalNames();

    public int getStackSize();

    public static class Empty
    extends FilterableList.Empty<TypeDescription, TypeList>
    implements TypeList {
        @Override
        public String[] toInternalNames() {
            return null;
        }

        @Override
        public int getStackSize() {
            return 0;
        }
    }

    public static class Explicit
    extends FilterableList.AbstractBase<TypeDescription, TypeList>
    implements TypeList {
        private final List<? extends TypeDescription> typeDescriptions;

        public Explicit(List<? extends TypeDescription> typeDescriptions) {
            this.typeDescriptions = typeDescriptions;
        }

        @Override
        public TypeDescription get(int index) {
            return this.typeDescriptions.get(index);
        }

        @Override
        public int size() {
            return this.typeDescriptions.size();
        }

        @Override
        public String[] toInternalNames() {
            String[] internalNames = new String[this.typeDescriptions.size()];
            int i = 0;
            for (TypeDescription typeDescription : this.typeDescriptions) {
                internalNames[i++] = typeDescription.getInternalName();
            }
            return internalNames.length == 0 ? null : internalNames;
        }

        @Override
        public int getStackSize() {
            int stackSize = 0;
            for (TypeDescription typeDescription : this.typeDescriptions) {
                stackSize += typeDescription.getStackSize().getSize();
            }
            return stackSize;
        }

        @Override
        protected TypeList wrap(List<TypeDescription> values) {
            return new Explicit(values);
        }
    }

    public static class ForLoadedType
    extends FilterableList.AbstractBase<TypeDescription, TypeList>
    implements TypeList {
        private final List<? extends Class<?>> types;

        public ForLoadedType(Class<?> ... type) {
            this(Arrays.asList(type));
        }

        public ForLoadedType(List<? extends Class<?>> types) {
            this.types = types;
        }

        @Override
        public TypeDescription get(int index) {
            return new TypeDescription.ForLoadedType(this.types.get(index));
        }

        @Override
        public int size() {
            return this.types.size();
        }

        @Override
        public String[] toInternalNames() {
            String[] internalNames = new String[this.types.size()];
            int i = 0;
            for (Class<?> type : this.types) {
                internalNames[i++] = Type.getInternalName(type);
            }
            return internalNames.length == 0 ? null : internalNames;
        }

        @Override
        public int getStackSize() {
            return StackSize.sizeOf(this.types);
        }

        @Override
        protected TypeList wrap(List<TypeDescription> values) {
            return new Explicit(values);
        }
    }
}

