/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.attribute;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.attribute.AnnotationAppender;
import org.objectweb.asm.MethodVisitor;

public interface MethodAttributeAppender {
    public void apply(MethodVisitor var1, MethodDescription var2);

    public static class Compound
    implements MethodAttributeAppender {
        private final MethodAttributeAppender[] methodAttributeAppender;

        public Compound(MethodAttributeAppender ... methodAttributeAppender) {
            this.methodAttributeAppender = methodAttributeAppender;
        }

        @Override
        public void apply(MethodVisitor methodVisitor, MethodDescription methodDescription) {
            for (MethodAttributeAppender methodAttributeAppender : this.methodAttributeAppender) {
                methodAttributeAppender.apply(methodVisitor, methodDescription);
            }
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && Arrays.equals(this.methodAttributeAppender, ((Compound)other).methodAttributeAppender);
        }

        public int hashCode() {
            return Arrays.hashCode(this.methodAttributeAppender);
        }

        public String toString() {
            return "MethodAttributeAppender.Compound{methodAttributeAppender=" + Arrays.toString(this.methodAttributeAppender) + '}';
        }
    }

    public static class ForLoadedConstructor
    implements MethodAttributeAppender,
    Factory {
        private final Constructor<?> constructor;

        public ForLoadedConstructor(Constructor<?> constructor) {
            this.constructor = constructor;
        }

        @Override
        public void apply(MethodVisitor methodVisitor, MethodDescription methodDescription) {
            if (this.constructor.getParameterTypes().length > methodDescription.getParameters().size()) {
                throw new IllegalArgumentException("The constructor " + this.constructor + " has more parameters than the instrumented method " + methodDescription);
            }
            ForInstrumentedMethod.INSTANCE.apply(methodVisitor, new MethodDescription.ForLoadedConstructor(this.constructor));
        }

        @Override
        public MethodAttributeAppender make(TypeDescription typeDescription) {
            return this;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.constructor.equals(((ForLoadedConstructor)other).constructor);
        }

        public int hashCode() {
            return this.constructor.hashCode();
        }

        public String toString() {
            return "MethodAttributeAppender.ForLoadedConstructor{constructor=" + this.constructor + '}';
        }
    }

    public static class ForLoadedMethod
    implements MethodAttributeAppender,
    Factory {
        private final Method method;

        public ForLoadedMethod(Method method) {
            this.method = method;
        }

        @Override
        public void apply(MethodVisitor methodVisitor, MethodDescription methodDescription) {
            if (this.method.getParameterTypes().length > methodDescription.getParameters().size()) {
                throw new IllegalArgumentException("The constructor " + this.method + " has more parameters than the instrumented method " + methodDescription);
            }
            ForInstrumentedMethod.INSTANCE.apply(methodVisitor, new MethodDescription.ForLoadedMethod(this.method));
        }

        @Override
        public MethodAttributeAppender make(TypeDescription typeDescription) {
            return this;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.method.equals(((ForLoadedMethod)other).method);
        }

        public int hashCode() {
            return this.method.hashCode();
        }

        public String toString() {
            return "MethodAttributeAppender.ForLoadedMethod{method=" + this.method + '}';
        }
    }

    public static class ForAnnotation
    implements MethodAttributeAppender,
    Factory {
        private final List<? extends AnnotationDescription> annotations;
        private final Target target;

        public ForAnnotation(List<? extends AnnotationDescription> annotations) {
            this.annotations = annotations;
            this.target = Target.OnMethod.INSTANCE;
        }

        public ForAnnotation(int parameterIndex, List<? extends AnnotationDescription> annotations) {
            this.annotations = annotations;
            this.target = new Target.OnMethodParameter(parameterIndex);
        }

        @Override
        public void apply(MethodVisitor methodVisitor, MethodDescription methodDescription) {
            AnnotationAppender.Default appender = new AnnotationAppender.Default(this.target.make(methodVisitor, methodDescription));
            for (AnnotationDescription annotationDescription : this.annotations) {
                appender.append(annotationDescription, AnnotationAppender.AnnotationVisibility.of(annotationDescription));
            }
        }

        @Override
        public MethodAttributeAppender make(TypeDescription typeDescription) {
            return this;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.annotations.equals(((ForAnnotation)other).annotations) && this.target.equals(((ForAnnotation)other).target);
        }

        public int hashCode() {
            return 31 * this.annotations.hashCode() + this.target.hashCode();
        }

        public String toString() {
            return "MethodAttributeAppender.ForAnnotation{annotations=" + this.annotations + ", target=" + this.target + '}';
        }

        protected static interface Target {
            public AnnotationAppender.Target make(MethodVisitor var1, MethodDescription var2);

            public static class OnMethodParameter
            implements Target {
                private final int parameterIndex;

                protected OnMethodParameter(int parameterIndex) {
                    this.parameterIndex = parameterIndex;
                }

                @Override
                public AnnotationAppender.Target make(MethodVisitor methodVisitor, MethodDescription methodDescription) {
                    if (this.parameterIndex >= methodDescription.getParameters().size()) {
                        throw new IllegalArgumentException("Method " + methodDescription + " has less then " + this.parameterIndex + " parameters");
                    }
                    return new AnnotationAppender.Target.OnMethodParameter(methodVisitor, this.parameterIndex);
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.parameterIndex == ((OnMethodParameter)other).parameterIndex;
                }

                public int hashCode() {
                    return this.parameterIndex;
                }

                public String toString() {
                    return "MethodAttributeAppender.ForAnnotation.Target.OnMethodParameter{parameterIndex=" + this.parameterIndex + '}';
                }
            }

            public static enum OnMethod implements Target
            {
                INSTANCE;


                @Override
                public AnnotationAppender.Target make(MethodVisitor methodVisitor, MethodDescription methodDescription) {
                    return new AnnotationAppender.Target.OnMethod(methodVisitor);
                }

                public String toString() {
                    return "MethodAttributeAppender.ForAnnotation.Target.OnMethod." + this.name();
                }
            }
        }
    }

    public static interface Factory {
        public MethodAttributeAppender make(TypeDescription var1);

        public static class Compound
        implements Factory {
            private final Factory[] factory;

            public Compound(Factory ... factory) {
                this.factory = factory;
            }

            @Override
            public MethodAttributeAppender make(TypeDescription typeDescription) {
                MethodAttributeAppender[] methodAttributeAppender = new MethodAttributeAppender[this.factory.length];
                int index = 0;
                for (Factory factory : this.factory) {
                    methodAttributeAppender[index++] = factory.make(typeDescription);
                }
                return new net.bytebuddy.implementation.attribute.MethodAttributeAppender$Compound(methodAttributeAppender);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && Arrays.equals(this.factory, ((Compound)other).factory);
            }

            public int hashCode() {
                return Arrays.hashCode(this.factory);
            }

            public String toString() {
                return "MethodAttributeAppender.Factory.Compound{factory=" + Arrays.toString(this.factory) + '}';
            }
        }
    }

    public static enum ForInstrumentedMethod implements MethodAttributeAppender,
    Factory
    {
        INSTANCE;


        @Override
        public void apply(MethodVisitor methodVisitor, MethodDescription methodDescription) {
            AnnotationAppender.Default methodAppender = new AnnotationAppender.Default(new AnnotationAppender.Target.OnMethod(methodVisitor));
            for (AnnotationDescription annotation : methodDescription.getDeclaredAnnotations()) {
                methodAppender.append(annotation, AnnotationAppender.AnnotationVisibility.of(annotation));
            }
            int index = 0;
            for (ParameterDescription parameterDescription : methodDescription.getParameters()) {
                AnnotationAppender.Default parameterAppender = new AnnotationAppender.Default(new AnnotationAppender.Target.OnMethodParameter(methodVisitor, index++));
                for (AnnotationDescription annotation : parameterDescription.getDeclaredAnnotations()) {
                    parameterAppender.append(annotation, AnnotationAppender.AnnotationVisibility.of(annotation));
                }
            }
        }

        @Override
        public MethodAttributeAppender make(TypeDescription typeDescription) {
            return this;
        }

        public String toString() {
            return "MethodAttributeAppender.ForInstrumentedMethod." + this.name();
        }
    }

    public static enum NoOp implements MethodAttributeAppender,
    Factory
    {
        INSTANCE;


        @Override
        public MethodAttributeAppender make(TypeDescription typeDescription) {
            return this;
        }

        @Override
        public void apply(MethodVisitor methodVisitor, MethodDescription methodDescription) {
        }

        public String toString() {
            return "MethodAttributeAppender.NoOp." + this.name();
        }
    }
}

