/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.bytecode.assign.primitive;

import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.StackSize;
import org.objectweb.asm.MethodVisitor;

public enum PrimitiveWideningDelegate {
    BOOLEAN(StackManipulation.LegalTrivial.INSTANCE, StackManipulation.Illegal.INSTANCE, StackManipulation.Illegal.INSTANCE, StackManipulation.Illegal.INSTANCE, StackManipulation.Illegal.INSTANCE, StackManipulation.Illegal.INSTANCE, StackManipulation.Illegal.INSTANCE, StackManipulation.Illegal.INSTANCE),
    BYTE(StackManipulation.Illegal.INSTANCE, StackManipulation.LegalTrivial.INSTANCE, StackManipulation.LegalTrivial.INSTANCE, StackManipulation.Illegal.INSTANCE, StackManipulation.LegalTrivial.INSTANCE, new WideningStackManipulation(133, StackSize.SINGLE.toIncreasingSize()), new WideningStackManipulation(134, StackSize.ZERO.toIncreasingSize()), new WideningStackManipulation(133, StackSize.SINGLE.toIncreasingSize())),
    SHORT(StackManipulation.Illegal.INSTANCE, StackManipulation.Illegal.INSTANCE, StackManipulation.LegalTrivial.INSTANCE, StackManipulation.Illegal.INSTANCE, StackManipulation.LegalTrivial.INSTANCE, new WideningStackManipulation(133, StackSize.SINGLE.toIncreasingSize()), new WideningStackManipulation(134, StackSize.ZERO.toIncreasingSize()), new WideningStackManipulation(135, StackSize.SINGLE.toIncreasingSize())),
    CHARACTER(StackManipulation.Illegal.INSTANCE, StackManipulation.Illegal.INSTANCE, StackManipulation.Illegal.INSTANCE, StackManipulation.LegalTrivial.INSTANCE, StackManipulation.LegalTrivial.INSTANCE, new WideningStackManipulation(133, StackSize.SINGLE.toIncreasingSize()), new WideningStackManipulation(134, StackSize.ZERO.toIncreasingSize()), new WideningStackManipulation(135, StackSize.SINGLE.toIncreasingSize())),
    INTEGER(StackManipulation.Illegal.INSTANCE, StackManipulation.Illegal.INSTANCE, StackManipulation.Illegal.INSTANCE, StackManipulation.Illegal.INSTANCE, StackManipulation.LegalTrivial.INSTANCE, new WideningStackManipulation(133, StackSize.SINGLE.toIncreasingSize()), new WideningStackManipulation(134, StackSize.ZERO.toIncreasingSize()), new WideningStackManipulation(135, StackSize.SINGLE.toIncreasingSize())),
    LONG(StackManipulation.Illegal.INSTANCE, StackManipulation.Illegal.INSTANCE, StackManipulation.Illegal.INSTANCE, StackManipulation.Illegal.INSTANCE, StackManipulation.Illegal.INSTANCE, StackManipulation.LegalTrivial.INSTANCE, new WideningStackManipulation(137, StackSize.SINGLE.toDecreasingSize()), new WideningStackManipulation(138, StackSize.ZERO.toIncreasingSize())),
    FLOAT(StackManipulation.Illegal.INSTANCE, StackManipulation.Illegal.INSTANCE, StackManipulation.Illegal.INSTANCE, StackManipulation.Illegal.INSTANCE, StackManipulation.Illegal.INSTANCE, StackManipulation.Illegal.INSTANCE, StackManipulation.LegalTrivial.INSTANCE, new WideningStackManipulation(141, StackSize.SINGLE.toIncreasingSize())),
    DOUBLE(StackManipulation.Illegal.INSTANCE, StackManipulation.Illegal.INSTANCE, StackManipulation.Illegal.INSTANCE, StackManipulation.Illegal.INSTANCE, StackManipulation.Illegal.INSTANCE, StackManipulation.Illegal.INSTANCE, StackManipulation.Illegal.INSTANCE, StackManipulation.LegalTrivial.INSTANCE);

    private final StackManipulation toBooleanStackManipulation;
    private final StackManipulation toByteStackManipulation;
    private final StackManipulation toShortStackManipulation;
    private final StackManipulation toCharacterStackManipulation;
    private final StackManipulation toIntegerStackManipulation;
    private final StackManipulation toLongStackManipulation;
    private final StackManipulation toFloatStackManipulation;
    private final StackManipulation toDoubleStackManipulation;

    private PrimitiveWideningDelegate(StackManipulation toBooleanStackManipulation, StackManipulation toByteStackManipulation, StackManipulation toShortStackManipulation, StackManipulation toCharacterStackManipulation, StackManipulation toIntegerStackManipulation, StackManipulation toLongStackManipulation, StackManipulation toFloatStackManipulation, StackManipulation toDoubleStackManipulation) {
        this.toBooleanStackManipulation = toBooleanStackManipulation;
        this.toByteStackManipulation = toByteStackManipulation;
        this.toShortStackManipulation = toShortStackManipulation;
        this.toCharacterStackManipulation = toCharacterStackManipulation;
        this.toIntegerStackManipulation = toIntegerStackManipulation;
        this.toLongStackManipulation = toLongStackManipulation;
        this.toFloatStackManipulation = toFloatStackManipulation;
        this.toDoubleStackManipulation = toDoubleStackManipulation;
    }

    public static PrimitiveWideningDelegate forPrimitive(TypeDescription typeDescription) {
        if (typeDescription.represents(Boolean.TYPE)) {
            return BOOLEAN;
        }
        if (typeDescription.represents(Byte.TYPE)) {
            return BYTE;
        }
        if (typeDescription.represents(Short.TYPE)) {
            return SHORT;
        }
        if (typeDescription.represents(Character.TYPE)) {
            return CHARACTER;
        }
        if (typeDescription.represents(Integer.TYPE)) {
            return INTEGER;
        }
        if (typeDescription.represents(Long.TYPE)) {
            return LONG;
        }
        if (typeDescription.represents(Float.TYPE)) {
            return FLOAT;
        }
        if (typeDescription.represents(Double.TYPE)) {
            return DOUBLE;
        }
        throw new IllegalArgumentException("Not a primitive, non-void type: " + typeDescription);
    }

    public StackManipulation widenTo(TypeDescription typeDescription) {
        if (typeDescription.represents(Boolean.TYPE)) {
            return this.toBooleanStackManipulation;
        }
        if (typeDescription.represents(Byte.TYPE)) {
            return this.toByteStackManipulation;
        }
        if (typeDescription.represents(Short.TYPE)) {
            return this.toShortStackManipulation;
        }
        if (typeDescription.represents(Character.TYPE)) {
            return this.toCharacterStackManipulation;
        }
        if (typeDescription.represents(Integer.TYPE)) {
            return this.toIntegerStackManipulation;
        }
        if (typeDescription.represents(Long.TYPE)) {
            return this.toLongStackManipulation;
        }
        if (typeDescription.represents(Float.TYPE)) {
            return this.toFloatStackManipulation;
        }
        if (typeDescription.represents(Double.TYPE)) {
            return this.toDoubleStackManipulation;
        }
        throw new IllegalArgumentException("Not a primitive non-void type: " + typeDescription);
    }

    public String toString() {
        return "PrimitiveWideningDelegate." + this.name();
    }

    protected static class WideningStackManipulation
    implements StackManipulation {
        private final int conversionOpcode;
        private final StackManipulation.Size size;

        protected WideningStackManipulation(int conversionOpcode, StackManipulation.Size size) {
            this.conversionOpcode = conversionOpcode;
            this.size = size;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            methodVisitor.visitInsn(this.conversionOpcode);
            return this.size;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.conversionOpcode == ((WideningStackManipulation)other).conversionOpcode && this.size.equals(((WideningStackManipulation)other).size);
        }

        public int hashCode() {
            return 31 * this.conversionOpcode + this.size.hashCode();
        }

        public String toString() {
            return "PrimitiveWideningDelegate.WideningStackManipulation{conversionOpcode=" + this.conversionOpcode + ", size=" + this.size + '}';
        }
    }
}

