/*
 * Decompiled with CFR 0.152.
 */
package net.contargo.validation.bigdecimal;

import java.math.BigDecimal;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import net.contargo.validation.bigdecimal.BigDecimalValidate;
import net.contargo.validation.bigdecimal.BigDecimalValidationResult;
import net.contargo.validation.bigdecimal.BigDecimalValidationRules;
import net.contargo.validation.bigdecimal.BigDecimalValidator;

public final class BigDecimalConstraintValidator
implements ConstraintValidator<BigDecimalValidate, Object> {
    private long maxDecimalPlaces;
    private long minDecimalPlaces;
    private long maxFractionalPlaces;
    private double minValue;
    private double maxValue;
    private BigDecimalValidator bigDecimalValidator;

    public void initialize(BigDecimalValidate bigDecimalValidate) {
        this.maxDecimalPlaces = bigDecimalValidate.maxDecimalPlaces();
        this.minDecimalPlaces = bigDecimalValidate.minDecimalPlaces();
        this.maxFractionalPlaces = bigDecimalValidate.maxFractionalPlaces();
        this.minValue = bigDecimalValidate.minValue();
        this.maxValue = bigDecimalValidate.maxValue();
        this.bigDecimalValidator = new BigDecimalValidator();
    }

    public boolean isValid(Object object, ConstraintValidatorContext constraintValidatorContext) {
        if (object == null) {
            return true;
        }
        if (object instanceof BigDecimal) {
            BigDecimalValidationRules bigDecimalValidationRules;
            BigDecimal bigDecimal = new BigDecimal(object.toString());
            BigDecimalValidationResult result = this.bigDecimalValidator.validate(bigDecimal, bigDecimalValidationRules = new BigDecimalValidationRules.Builder().maxDecimalPlaces(this.maxDecimalPlaces).minDecimalPlaces(this.minDecimalPlaces).maxFractionalPlaces(this.maxFractionalPlaces).minValue(this.minValue).maxValue(this.maxValue).build());
            if (!result.isValid()) {
                this.addMessage(constraintValidatorContext, result.getFailMessage());
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public void setBigDecimalValidator(BigDecimalValidator bigDecimalValidator) {
        this.bigDecimalValidator = bigDecimalValidator;
    }

    private void addMessage(ConstraintValidatorContext constraintValidatorContext, String message) {
        if (constraintValidatorContext != null) {
            constraintValidatorContext.disableDefaultConstraintViolation();
            constraintValidatorContext.buildConstraintViolationWithTemplate(message).addConstraintViolation();
        }
    }
}

