/*
 * Decompiled with CFR 0.152.
 */
package net.contargo.validation.bigdecimal;

import java.math.BigDecimal;

public final class BigDecimalValidationRules {
    private final long minDecimalPlaces;
    private final long maxDecimalPlaces;
    private final long maxFractionalPlaces;
    private final BigDecimal minValue;
    private final BigDecimal maxValue;

    public BigDecimalValidationRules(Builder builder) {
        this.minDecimalPlaces = builder.minDecimalPlaces;
        this.maxDecimalPlaces = builder.maxDecimalPlaces;
        this.maxFractionalPlaces = builder.maxFractionalPlaces;
        this.minValue = builder.minValue;
        this.maxValue = builder.maxValue;
    }

    public long getMinDecimalPlaces() {
        return this.minDecimalPlaces;
    }

    public long getMaxDecimalPlaces() {
        return this.maxDecimalPlaces;
    }

    public long getMaxFractionalPlaces() {
        return this.maxFractionalPlaces;
    }

    public BigDecimal getMinValue() {
        return this.minValue;
    }

    public BigDecimal getMaxValue() {
        return this.maxValue;
    }

    public static class Builder {
        private static final int MAX_DECIMAL_PLACES = 10;
        private static final int MIN_DECIMAL_PLACES = 1;
        private static final int MAX_FRACTIONAL_PLACES = 2;
        private long minDecimalPlaces = 1L;
        private long maxDecimalPlaces = 10L;
        private long maxFractionalPlaces = 2L;
        private BigDecimal minValue = new BigDecimal(-1.7976931348623157E308);
        private BigDecimal maxValue = new BigDecimal(Double.MAX_VALUE);

        public Builder minDecimalPlaces(long minDecimalPlaces) {
            this.minDecimalPlaces = minDecimalPlaces;
            return this;
        }

        public Builder maxDecimalPlaces(long maxDecimalPlaces) {
            this.maxDecimalPlaces = maxDecimalPlaces;
            return this;
        }

        public Builder maxFractionalPlaces(long maxFractionalPlaces) {
            this.maxFractionalPlaces = maxFractionalPlaces;
            return this;
        }

        public Builder minValue(double minValue) {
            this.minValue = new BigDecimal(String.valueOf(minValue));
            return this;
        }

        public Builder maxValue(double maxValue) {
            this.maxValue = new BigDecimal(String.valueOf(maxValue));
            return this;
        }

        public BigDecimalValidationRules build() {
            return new BigDecimalValidationRules(this);
        }
    }
}

