package net.dreamlu.module.ueditor;

import javax.servlet.http.HttpServletRequest;

import org.springframework.util.StringUtils;

import net.dreamlu.module.ueditor.define.ActionMap;
import net.dreamlu.module.ueditor.define.AppInfo;
import net.dreamlu.module.ueditor.define.BaseState;
import net.dreamlu.module.ueditor.define.State;
import net.dreamlu.module.ueditor.hunter.ImageHunter;
import net.dreamlu.module.ueditor.manager.IUeditorFileManager;
import net.dreamlu.module.ueditor.uploader.Uploader;

public class UeditorService {
	private UeditorManager ueditorManager;
	
	public UeditorService() {}

	public UeditorService(UeditorManager ueditorManager) {
		this.ueditorManager = ueditorManager;
	}
	
	public String exec(HttpServletRequest request) {
		String callbackName = request.getParameter("callback");
		if (callbackName != null) {
			if (!validCallbackName(callbackName)) {
				return new BaseState(false, AppInfo.ILLEGAL).toJSONString();
			}
			return callbackName + "(" + invoke(request) + ");";
		} else {
			return invoke(request);
		}
	}

	private String invoke(HttpServletRequest request) {
		String actionType = request.getParameter("action");
		String rootPath = request.getServletContext().getRealPath("/");
		String ctxPath  = request.getContextPath();
		
		if (actionType == null || !ActionMap.mapping.containsKey(actionType)) {
			return new BaseState(false, AppInfo.INVALID_ACTION).toJSONString();
		}
		if (ueditorManager == null || !ueditorManager.valid()) {
			return new BaseState(false, AppInfo.CONFIG_ERROR).toJSONString();
		}

		IUeditorFileManager fileManager = ueditorManager.getFileManager();
		
		State state = null;
		int actionCode = ActionMap.getType(actionType);
		ActionConfig conf = null;

		switch (actionCode) {

		case ActionMap.CONFIG:
			UeditorConfig allConfig = ueditorManager.getConfig();
			String imageUrlPrefix = allConfig.getImageUrlPrefix();
			String scrawlUrlPrefix = allConfig.getScrawlUrlPrefix();
			String snapscreenUrlPrefix = allConfig.getSnapscreenUrlPrefix();
			String catcherUrlPrefix = allConfig.getCatcherUrlPrefix();
			String videoUrlPrefix = allConfig.getVideoUrlPrefix();
			String fileUrlPrefix = allConfig.getFileUrlPrefix();
			String imageManagerUrlPrefix = allConfig.getImageManagerUrlPrefix();
			String fileManagerUrlPrefix = allConfig.getFileManagerUrlPrefix();

			if (StringUtils.hasText(imageUrlPrefix)) {
				allConfig.setImageUrlPrefix(ctxPath);
			}
			if (StringUtils.hasText(scrawlUrlPrefix)) {
				allConfig.setScrawlUrlPrefix(ctxPath);
			}
			if (StringUtils.hasText(snapscreenUrlPrefix)) {
				allConfig.setSnapscreenUrlPrefix(ctxPath);
			}
			if (StringUtils.hasText(catcherUrlPrefix)) {
				allConfig.setCatcherUrlPrefix(ctxPath);
			}
			if (StringUtils.hasText(videoUrlPrefix)) {
				allConfig.setVideoUrlPrefix(ctxPath);
			}
			if (StringUtils.hasText(fileUrlPrefix)) {
				allConfig.setFileUrlPrefix(ctxPath);
			}
			if (StringUtils.hasText(imageManagerUrlPrefix)) {
				allConfig.setImageManagerUrlPrefix(ctxPath);
			}
			if (StringUtils.hasText(fileManagerUrlPrefix)) {
				allConfig.setFileManagerUrlPrefix(ctxPath);
			}
			return JsonUtils.toJson(allConfig);

		case ActionMap.UPLOAD_IMAGE:
		case ActionMap.UPLOAD_SCRAWL:
		case ActionMap.UPLOAD_VIDEO:
		case ActionMap.UPLOAD_FILE:
			conf = ueditorManager.getConfig(actionCode, rootPath);
			state = new Uploader(request, conf).doExec(fileManager);
			break;

		case ActionMap.CATCH_IMAGE:
			conf = ueditorManager.getConfig(actionCode, rootPath);
			String[] list = request.getParameterValues(conf.getFieldName());
			state = new ImageHunter(fileManager, conf).capture(list);
			break;

		case ActionMap.LIST_IMAGE:
		case ActionMap.LIST_FILE:
			conf = ueditorManager.getConfig(actionCode, rootPath);
			int start = getStartIndex(request);
			state = fileManager.list(conf, start);
			break;

		}
		return state.toJSONString();
	}

	public int getStartIndex(HttpServletRequest request) {
		String start = request.getParameter("start");
		try {
			return Integer.parseInt(start);
		} catch (Exception e) {
			return 0;
		}
	}

	/**
	 * callback参数验证
	 * @param name 参数名
	 * @return boolean 是否校验通过
	 */
	public boolean validCallbackName(String name) {
		return name.matches("^[a-zA-Z_]+[\\w0-9_]*$");
	}

	public void setUeditorManager(UeditorManager ueditorManager) {
		this.ueditorManager = ueditorManager;
	}

	public UeditorManager getUeditorManager() {
		return ueditorManager;
	}
}
