package net.dreamlu.module.ueditor.uploader;

import org.springframework.util.Base64Utils;

import net.dreamlu.module.ueditor.ActionConfig;
import net.dreamlu.module.ueditor.PathFormat;
import net.dreamlu.module.ueditor.define.AppInfo;
import net.dreamlu.module.ueditor.define.BaseState;
import net.dreamlu.module.ueditor.define.FileType;
import net.dreamlu.module.ueditor.define.State;
import net.dreamlu.module.ueditor.manager.IUeditorFileManager;


public final class Base64Uploader {

	public static State save(IUeditorFileManager fileManager, String content, ActionConfig conf) {
		byte[] data = decode(content);
		long maxSize = conf.getMaxSize();

		if (!validSize(data, maxSize)) {
			return new BaseState(false, AppInfo.MAX_SIZE);
		}

		String suffix = FileType.getSuffix("JPG");

		String savePath = PathFormat.parse(conf.getSavePath(),  conf.getFilename());

		savePath = savePath + suffix;
		String rootPath = conf.getRootPath();

		State storageState = fileManager.saveFile(data, rootPath, savePath);

		if (storageState.isSuccess()) {
			storageState.putInfo("url", PathFormat.format(savePath));
			storageState.putInfo("type", suffix);
			storageState.putInfo("original", "");
		}
		return storageState;
	}

	private static byte[] decode(String content) {
		return Base64Utils.decodeFromString(content);
	}

	private static boolean validSize(byte[] data, long length) {
		return data.length <= length;
	}

}