/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.module.ueditor.manager;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.dreamlu.module.ueditor.ActionConfig;
import net.dreamlu.module.ueditor.PathFormat;
import net.dreamlu.module.ueditor.define.BaseState;
import net.dreamlu.module.ueditor.define.MultiState;
import net.dreamlu.module.ueditor.define.State;
import net.dreamlu.module.ueditor.manager.IUeditorFileManager;
import net.dreamlu.module.ueditor.manager.ManagerUtils;
import org.apache.commons.io.FileUtils;

public class DefaultFileManager
implements IUeditorFileManager {
    public static final int BUFFER_SIZE = 8192;

    private State getState(String rootPath, File[] files) {
        MultiState state = new MultiState(true);
        for (File file : files) {
            if (file == null) break;
            BaseState fileState = new BaseState(true);
            String path = file.getAbsolutePath().replace(rootPath, "/").replace("\\", "/").replace("//", "/");
            fileState.putInfo("url", PathFormat.format(path));
            state.addState(fileState);
        }
        return state;
    }

    @Override
    public State list(ActionConfig conf, int start) {
        String rootPath = conf.getRootPath();
        String dirPath = rootPath + conf.getDir();
        List<String> allowFiles = ManagerUtils.getAllowFiles(conf.getAllowFiles());
        int count = conf.getCount();
        File dir = new File(dirPath);
        if (!dir.exists()) {
            return new BaseState(false, 302);
        }
        if (!dir.isDirectory()) {
            return new BaseState(false, 301);
        }
        Collection list = FileUtils.listFiles((File)dir, (String[])allowFiles.toArray(new String[0]), (boolean)true);
        Collections.reverse((List)list);
        State state = null;
        if (start < 0 || start > list.size()) {
            state = new MultiState(true);
        } else {
            File[] fileList = Arrays.copyOfRange(list.toArray(new File[0]), start, start + count);
            state = this.getState(rootPath, fileList);
        }
        state.putInfo("start", start);
        state.putInfo("total", list.size());
        return state;
    }

    @Override
    public State saveFile(byte[] data, String rootPath, String savePath) {
        File file = new File(rootPath + savePath);
        State state = DefaultFileManager.valid(file);
        if (!state.isSuccess()) {
            return state;
        }
        try {
            FileUtils.writeByteArrayToFile((File)file, (byte[])data);
        }
        catch (IOException ioe) {
            return new BaseState(false, 4);
        }
        state = new BaseState(true, file.getAbsolutePath());
        state.putInfo("size", data.length);
        state.putInfo("title", file.getName());
        return state;
    }

    @Override
    public State saveFile(InputStream is, String rootPath, String savePath, long maxSize) {
        byte[] dataBuf = new byte[8192];
        BufferedInputStream bis = new BufferedInputStream(is, 8192);
        try {
            File tmpFile = DefaultFileManager.getTmpFile();
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(tmpFile), 8192);
            int count = 0;
            while ((count = bis.read(dataBuf)) != -1) {
                bos.write(dataBuf, 0, count);
            }
            bos.flush();
            bos.close();
            if (tmpFile.length() > maxSize) {
                tmpFile.delete();
                return new BaseState(false, 1);
            }
            State state = DefaultFileManager.saveTmpFile(tmpFile, rootPath + savePath);
            if (!state.isSuccess()) {
                tmpFile.delete();
            }
            return state;
        }
        catch (IOException iOException) {
            return new BaseState(false, 4);
        }
    }

    @Override
    public State saveFile(InputStream is, String rootPath, String savePath) {
        byte[] dataBuf = new byte[8192];
        BufferedInputStream bis = new BufferedInputStream(is, 8192);
        State state = null;
        try {
            File tmpFile = DefaultFileManager.getTmpFile();
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(tmpFile), 8192);
            int count = 0;
            while ((count = bis.read(dataBuf)) != -1) {
                bos.write(dataBuf, 0, count);
            }
            bos.flush();
            bos.close();
            state = DefaultFileManager.saveTmpFile(tmpFile, rootPath + savePath);
            if (!state.isSuccess()) {
                tmpFile.delete();
            }
            return state;
        }
        catch (IOException iOException) {
            return new BaseState(false, 4);
        }
    }

    private static File getTmpFile() throws IOException {
        File tmpDir = FileUtils.getTempDirectory();
        if (!tmpDir.exists()) {
            tmpDir.mkdirs();
        }
        String tmpFileName = (Math.random() * 10000.0 + "").replace(".", "");
        return new File(tmpDir, tmpFileName);
    }

    private static State saveTmpFile(File tmpFile, String path) {
        File targetFile = new File(path);
        if (targetFile.canWrite()) {
            return new BaseState(false, 2);
        }
        try {
            FileUtils.moveFile((File)tmpFile, (File)targetFile);
        }
        catch (IOException e) {
            return new BaseState(false, 4);
        }
        BaseState state = new BaseState(true);
        state.putInfo("size", targetFile.length());
        state.putInfo("title", targetFile.getName());
        return state;
    }

    private static State valid(File file) {
        File parentPath = file.getParentFile();
        if (!parentPath.exists() && !parentPath.mkdirs()) {
            return new BaseState(false, 3);
        }
        if (!parentPath.canWrite()) {
            return new BaseState(false, 2);
        }
        return new BaseState(true);
    }
}

