/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.web;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import net.kaczmarzyk.spring.data.jpa.web.AndSpecificationResolver;
import net.kaczmarzyk.spring.data.jpa.web.SimpleSpecificationResolver;
import net.kaczmarzyk.spring.data.jpa.web.WebRequestProcessingContext;
import net.kaczmarzyk.spring.data.jpa.web.annotation.And;
import net.kaczmarzyk.spring.data.jpa.web.annotation.Disjunction;
import net.kaczmarzyk.spring.data.jpa.web.annotation.Spec;
import org.springframework.core.MethodParameter;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

class DisjunctionSpecificationResolver
implements HandlerMethodArgumentResolver {
    private SimpleSpecificationResolver specResolver = new SimpleSpecificationResolver();
    private AndSpecificationResolver andResolver = new AndSpecificationResolver();

    DisjunctionSpecificationResolver() {
    }

    public boolean supportsParameter(MethodParameter param) {
        return param.getParameterType() == Specification.class && param.hasParameterAnnotation(Disjunction.class);
    }

    public Specification<?> resolveArgument(MethodParameter param, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        Disjunction def = (Disjunction)param.getParameterAnnotation(Disjunction.class);
        WebRequestProcessingContext context = new WebRequestProcessingContext(param, webRequest);
        return this.buildSpecification(context, def);
    }

    Specification<Object> buildSpecification(WebRequestProcessingContext context, Disjunction def) {
        ArrayList innerSpecs = new ArrayList();
        for (And and : def.value()) {
            Specification<Object> innerAnd = this.andResolver.buildSpecification(context, and);
            if (innerAnd == null) continue;
            innerSpecs.add(innerAnd);
        }
        for (Annotation annotation : def.or()) {
            Specification<Object> innerSpec = this.specResolver.buildSpecification(context, (Spec)annotation);
            if (innerSpec == null) continue;
            innerSpecs.add(innerSpec);
        }
        return innerSpecs.isEmpty() ? null : new net.kaczmarzyk.spring.data.jpa.domain.Disjunction(innerSpecs);
    }
}

