/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.web;

import java.util.HashMap;
import java.util.function.Supplier;
import net.kaczmarzyk.spring.data.jpa.utils.QueryContext;
import org.springframework.web.context.request.NativeWebRequest;

public class WebRequestQueryContext
implements QueryContext {
    private static final String ATTRIBUTE_KEY = WebRequestQueryContext.class.getName() + ".ATTRIBUTE_KEY";
    private HashMap<String, Object> contextMap;

    public WebRequestQueryContext(NativeWebRequest request) {
        this.contextMap = (HashMap)request.getAttribute(ATTRIBUTE_KEY, 0);
        if (this.contextMap == null) {
            this.contextMap = new HashMap();
            request.setAttribute(ATTRIBUTE_KEY, this.contextMap, 0);
        }
    }

    @Override
    public Object getEvaluated(String key) {
        Object value = this.contextMap.get(key);
        if (value instanceof Supplier) {
            Object evaluated = ((Supplier)value).get();
            this.contextMap.put(key, evaluated);
            return evaluated;
        }
        return value;
    }

    @Override
    public void putLazyVal(String key, Supplier<Object> value) {
        this.contextMap.put(key, value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.contextMap == null ? 0 : this.contextMap.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WebRequestQueryContext other = (WebRequestQueryContext)obj;
        return !(this.contextMap == null ? other.contextMap != null : !this.contextMap.equals(other.contextMap));
    }

    public String toString() {
        return "WebRequestQueryContext [contextMap=" + this.contextMap + "]";
    }
}

