/*
 * Decompiled with CFR 0.152.
 */
package net.karneim.pojobuilder.model;

import net.karneim.pojobuilder.model.ImportTypesM;
import net.karneim.pojobuilder.model.TypeListM;
import net.karneim.pojobuilder.model.TypeM;

public class TypeVariableM
extends TypeM {
    private final TypeListM bounds = new TypeListM(new TypeM[0]);

    public TypeVariableM(String name) {
        super(name);
    }

    @Override
    public boolean isTypeVariable() {
        return true;
    }

    public TypeVariableM whichExtends(TypeM ... types) {
        for (TypeM bound : types) {
            this.bounds.add(bound);
        }
        return this;
    }

    public boolean hasBounds() {
        return !this.bounds.isEmpty();
    }

    public String getBoundsString() {
        StringBuilder result = new StringBuilder();
        for (TypeM bound : this.bounds) {
            if (result.length() > 0) {
                result.append(" & ");
            }
            result.append(bound.getGenericTypeDeclaration());
        }
        return result.toString();
    }

    @Override
    public String getGenericType() {
        if (!this.hasBounds()) {
            return this.getName();
        }
        return String.format("%s extends %s", this.getName(), this.getBoundsString());
    }

    @Override
    public ImportTypesM addToImportTypes(ImportTypesM result) {
        if (result.add(this)) {
            this.bounds.addToImportTypes(result);
        }
        return result;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypeVariableM other = (TypeVariableM)obj;
        return !(this.bounds == null ? other.bounds != null : !this.bounds.equals(other.bounds));
    }

    @Override
    public String toString() {
        return "TypeVariableM [getGenericType()=" + this.getGenericType() + "]";
    }
}

