/*
 * Decompiled with CFR 0.152.
 */
package net.karneim.pojobuilder.analysis;

import java.util.Map;
import net.karneim.pojobuilder.analysis.AnalysisException;

public class Directives {
    private boolean generateCopyMethod = false;
    private String copyMethodName = null;
    private String intoPackage = "*";
    private String builderName = "*Builder";
    private String baseclassName = Object.class.getName();
    private String builderInterfaceName = Void.class.getName();
    private boolean generateBuilderProperties = false;
    private boolean generationGap = false;
    private String setterNamePattern = "with*";
    private String staticFactoryMethod = "";
    private String validatorClassname = Void.class.getName();
    private String optionalClassname = Void.class.getName();

    public Directives(Map<String, Object> valueMap) {
        if (valueMap == null) {
            throw new NullPointerException("valueMap must not be null!");
        }
        this.baseclassName = (String)valueMap.get("withBaseclass");
        this.builderInterfaceName = (String)valueMap.get("withBuilderInterface");
        this.generateBuilderProperties = (Boolean)valueMap.get("withBuilderProperties");
        this.builderName = (String)valueMap.get("withName");
        this.intoPackage = (String)valueMap.get("intoPackage");
        this.generationGap = (Boolean)valueMap.get("withGenerationGap");
        this.generateCopyMethod = (Boolean)valueMap.get("withCopyMethod");
        if (this.generateCopyMethod) {
            this.copyMethodName = "copy";
        }
        this.setterNamePattern = (String)valueMap.get("withSetterNamePattern");
        this.staticFactoryMethod = (String)valueMap.get("withFactoryMethod");
        this.validatorClassname = (String)valueMap.get("withValidator");
        this.optionalClassname = (String)valueMap.get("withOptionalProperties");
    }

    public boolean isGenerateCopyMethod() {
        return this.generateCopyMethod;
    }

    public void setGenerateCopyMethod(boolean generateCopyMethod) {
        this.generateCopyMethod = generateCopyMethod;
    }

    public String getCopyMethodName() {
        return this.copyMethodName;
    }

    public void setCopyMethodName(String copyMethodName) {
        this.copyMethodName = copyMethodName;
    }

    public String getValidatorClassname() {
        return this.validatorClassname;
    }

    public void setValidatorClassname(String validatorClassname) {
        this.validatorClassname = validatorClassname;
    }

    public boolean isGenerationGap() {
        return this.generationGap;
    }

    public boolean isGenerateBuilderProperties() {
        return this.generateBuilderProperties;
    }

    public void setGenerateBuilderProperties(boolean generateBuilderProperties) {
        this.generateBuilderProperties = generateBuilderProperties;
    }

    public void setGenerationGap(boolean generationGap) {
        this.generationGap = generationGap;
    }

    public void setIntoPackage(String intoPackage) {
        if (intoPackage == null) {
            throw new IllegalArgumentException("intoPackage==null");
        }
        if (intoPackage.startsWith("java.")) {
            throw new AnalysisException("Value for attribute 'intoPackage' must not start with 'java.'");
        }
        this.intoPackage = intoPackage;
    }

    public String getIntoPackage() {
        return this.intoPackage;
    }

    public String getBuilderName() {
        return this.builderName;
    }

    public void setBuilderName(String builderName) {
        if (builderName == null || builderName.trim().isEmpty()) {
            throw new AnalysisException("Value for attribute 'withName' must not be empty.");
        }
        this.builderName = builderName;
    }

    public void setBaseclassName(String baseclassName) {
        this.baseclassName = baseclassName;
    }

    public String getBaseclassName() {
        return this.baseclassName;
    }

    public String getBuilderInterfaceName() {
        return this.builderInterfaceName;
    }

    public void setBuilderInterfaceName(String builderInterfaceName) {
        this.builderInterfaceName = builderInterfaceName;
    }

    public String getSetterNamePattern() {
        return this.setterNamePattern;
    }

    public void setSetterNamePattern(String pattern) {
        this.setterNamePattern = pattern;
    }

    public String getOptionalClassname() {
        return this.optionalClassname;
    }

    public void setOptionalClassname(String optionalClassname) {
        this.optionalClassname = optionalClassname;
    }

    public String getStaticFactoryMethod() {
        return this.staticFactoryMethod;
    }

    public void setStaticFactoryMethod(String staticFactoryMethod) {
        this.staticFactoryMethod = staticFactoryMethod;
    }

    public String toString() {
        return "Directives [generateCopyMethod=" + this.generateCopyMethod + ", copyMethodName=" + this.copyMethodName + ", intoPackage=" + this.intoPackage + ", builderName=" + this.builderName + ", baseclassName=" + this.baseclassName + ", builderInterfaceName=" + this.builderInterfaceName + ", generateBuilderProperties=" + this.generateBuilderProperties + ", generationGap=" + this.generationGap + ", setterNamePattern=" + this.setterNamePattern + ", validatorClassname=" + this.validatorClassname + ", staticFactoryMethod=" + this.staticFactoryMethod + ", optionalClassname=" + this.optionalClassname + "]";
    }
}

