/*
 * Decompiled with CFR 0.152.
 */
package net.karneim.pojobuilder.analysis;

import java.beans.ConstructorProperties;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import net.karneim.pojobuilder.analysis.InvalidElementException;
import net.karneim.pojobuilder.analysis.JavaModelAnalyzerUtil;
import net.karneim.pojobuilder.analysis.Output;
import net.karneim.pojobuilder.analysis.TypeMFactory;
import net.karneim.pojobuilder.model.ConstructorParameterM;
import net.karneim.pojobuilder.model.TypeM;

public class PojoConstructorScanner {
    private final JavaModelAnalyzerUtil javaModelAnalyzerUtil;
    private final TypeMFactory typeMFactory;

    public PojoConstructorScanner(JavaModelAnalyzerUtil javaModelAnalyzerUtil, TypeMFactory typeMFactory) {
        this.javaModelAnalyzerUtil = javaModelAnalyzerUtil;
        this.typeMFactory = typeMFactory;
    }

    public void scan(ExecutableElement constrEl, Output output) {
        ConstructorProperties constrPropsAnno = constrEl.getAnnotation(ConstructorProperties.class);
        if (constrPropsAnno == null) {
            List<? extends VariableElement> parameters = constrEl.getParameters();
            int i = 0;
            for (VariableElement variableElement : parameters) {
                String propertyName = variableElement.getSimpleName().toString();
                TypeMirror propertyTypeMirror = variableElement.asType();
                TypeM propertyType = this.typeMFactory.getTypeM(propertyTypeMirror);
                output.getBuilderModel().getProperties().getOrCreate(propertyName, propertyType).writableVia(new ConstructorParameterM(i).withName(propertyName).withVarArgs(constrEl.isVarArgs() && i == parameters.size() - 1));
                ++i;
            }
        } else {
            List<? extends VariableElement> parameters;
            String[] propertyNames = constrPropsAnno.value();
            if (propertyNames.length != (parameters = constrEl.getParameters()).size()) {
                String message = String.format("Incorrect number of values in annotation @%s! Expected %d, but was %d.", ConstructorProperties.class.getSimpleName(), parameters.size(), propertyNames.length);
                throw new InvalidElementException(message, constrEl);
            }
            for (int i = 0; i < propertyNames.length; ++i) {
                String string = propertyNames[i];
                if (!this.javaModelAnalyzerUtil.isValidJavaIdentifier(string)) {
                    String message = String.format("Illegal value in annotation @%s! Value '%s' is not a valid identifier.", ConstructorProperties.class.getSimpleName(), string);
                    throw new InvalidElementException(message, constrEl);
                }
                TypeMirror propertyTypeMirror = parameters.get(i).asType();
                TypeM propertyType = this.typeMFactory.getTypeM(propertyTypeMirror);
                output.getBuilderModel().getProperties().getOrCreate(string, propertyType).writableVia(new ConstructorParameterM(i).withName(string).withVarArgs(constrEl.isVarArgs() && i == parameters.size() - 1));
            }
        }
        output.getInput().getOrginatingElements().add(this.javaModelAnalyzerUtil.getCompilationUnit(constrEl));
    }
}

