/*
 * Decompiled with CFR 0.152.
 */
package net.karneim.pojobuilder.model;

import net.karneim.pojobuilder.model.ImportTypesM;
import net.karneim.pojobuilder.model.TypeListM;

public class TypeM {
    private final String packageName;
    private final String simpleName;
    private final String name;
    private final TypeListM typeParameters = new TypeListM(new TypeM[0]);

    protected TypeM(String name) {
        this("", name);
    }

    public TypeM(String packageName, String simpleName) {
        this.packageName = packageName == null ? "" : packageName;
        this.simpleName = simpleName;
        this.name = this.packageName.isEmpty() ? simpleName : this.packageName + "." + this.simpleName;
    }

    public TypeM(Class<?> aClass) {
        this(aClass.getPackage().getName(), aClass.getSimpleName());
    }

    public TypeM withTypeParameter(TypeM ... params) {
        for (TypeM p : params) {
            this.typeParameters.add(p);
        }
        return this;
    }

    public TypeListM getTypeParameters() {
        return this.typeParameters;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isTypeVariable() {
        return false;
    }

    public boolean isArrayType() {
        return false;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public boolean isGeneric() {
        return !this.typeParameters.isEmpty();
    }

    public String getGenericType() {
        if (!this.isGeneric()) {
            return this.name;
        }
        return String.format("%s<%s>", this.name, this.typeParameters.toParameterString());
    }

    public String getGenericTypeDeclaration() {
        if (!this.isGeneric()) {
            return this.name;
        }
        return String.format("%s<%s>", this.name, this.typeParameters.toArgumentString());
    }

    public ImportTypesM addToImportTypes(ImportTypesM result) {
        if (result.add(this)) {
            this.typeParameters.addToImportTypes(result);
        }
        return result;
    }

    public boolean isInPackage(String packageName) {
        return packageName == null && this.packageName.isEmpty() || packageName.equals(this.packageName);
    }

    public String toString() {
        return "TypeM [getGenericType()=" + this.getGenericType() + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypeM other = (TypeM)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.packageName == null ? other.packageName != null : !this.packageName.equals(other.packageName)) {
            return false;
        }
        if (this.simpleName == null ? other.simpleName != null : !this.simpleName.equals(other.simpleName)) {
            return false;
        }
        return !(this.typeParameters == null ? other.typeParameters != null : !this.typeParameters.equals(other.typeParameters));
    }
}

