/*
 * Decompiled with CFR 0.152.
 */
package net.karneim.pojobuilder.analysis;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import net.karneim.pojobuilder.Visibility;
import net.karneim.pojobuilder.analysis.AnalysisException;
import net.karneim.pojobuilder.analysis.PropertyPattern;

public class Directives {
    private boolean generateCopyMethod = false;
    private String copyMethodName = null;
    private String intoPackage = "*";
    private String builderName = "*Builder";
    private String baseclassName = Object.class.getName();
    private String builderInterfaceName = Void.class.getName();
    private boolean generateBuilderProperties = false;
    private boolean generationGap = false;
    private String setterNamePattern = "with*";
    private String staticFactoryMethod = "";
    private Visibility constructor = null;
    private String validatorClassname = Void.class.getName();
    private String optionalClassname = Void.class.getName();
    private List<PropertyPattern> includeProperties = new ArrayList<PropertyPattern>();
    private List<PropertyPattern> excludeProperties = new ArrayList<PropertyPattern>();

    public Directives(Map<String, Object> valueMap) {
        if (valueMap == null) {
            throw new NullPointerException("valueMap must not be null!");
        }
        this.setBaseclassName((String)valueMap.get("withBaseclass"));
        this.setBuilderInterfaceName((String)valueMap.get("withBuilderInterface"));
        this.setGenerateBuilderProperties((Boolean)valueMap.get("withBuilderProperties"));
        this.setBuilderName((String)valueMap.get("withName"));
        this.setIntoPackage((String)valueMap.get("intoPackage"));
        this.setGenerationGap((Boolean)valueMap.get("withGenerationGap"));
        this.setGenerateCopyMethod((Boolean)valueMap.get("withCopyMethod"));
        this.setSetterNamePattern((String)valueMap.get("withSetterNamePattern"));
        this.setStaticFactoryMethod((String)valueMap.get("withFactoryMethod"));
        this.setConstructor(this.toVisibility((Element)valueMap.get("withConstructor")));
        this.setValidatorClassname((String)valueMap.get("withValidator"));
        this.setOptionalClassname((String)valueMap.get("withOptionalProperties"));
        this.setIncludeProperties(this.newList((List)valueMap.get("includeProperties")));
        this.setExcludeProperties(this.newList((List)valueMap.get("excludeProperties")));
        if (this.constructor == Visibility.PRIVATE && this.staticFactoryMethod.isEmpty()) {
            throw new AnalysisException("Value for attribute 'withConstructor' must not be PRIVATE if value for attribute 'withFactoryMethod' is blank.");
        }
    }

    private Visibility toVisibility(Element object) {
        String name = object.getSimpleName().toString();
        Visibility visibility = Visibility.valueOf(name);
        return visibility;
    }

    private List<PropertyPattern> newList(List<AnnotationValue> array) {
        ArrayList<PropertyPattern> result = new ArrayList<PropertyPattern>(array.size());
        for (AnnotationValue elem : array) {
            result.add(new PropertyPattern(String.valueOf(elem.getValue())));
        }
        return result;
    }

    public boolean isGenerateCopyMethod() {
        return this.generateCopyMethod;
    }

    public void setGenerateCopyMethod(boolean generateCopyMethod) {
        this.generateCopyMethod = generateCopyMethod;
        this.copyMethodName = generateCopyMethod ? "copy" : null;
    }

    public String getCopyMethodName() {
        return this.copyMethodName;
    }

    public void setCopyMethodName(String copyMethodName) {
        this.copyMethodName = copyMethodName;
    }

    public String getValidatorClassname() {
        return this.validatorClassname;
    }

    public void setValidatorClassname(String validatorClassname) {
        this.validatorClassname = validatorClassname;
    }

    public boolean isGenerationGap() {
        return this.generationGap;
    }

    public boolean isGenerateBuilderProperties() {
        return this.generateBuilderProperties;
    }

    public void setGenerateBuilderProperties(boolean generateBuilderProperties) {
        this.generateBuilderProperties = generateBuilderProperties;
    }

    public void setGenerationGap(boolean generationGap) {
        this.generationGap = generationGap;
    }

    public void setIntoPackage(String intoPackage) {
        if (intoPackage == null) {
            throw new IllegalArgumentException("intoPackage==null");
        }
        if (intoPackage.startsWith("java.")) {
            throw new AnalysisException("Value for attribute 'intoPackage' must not start with 'java.'");
        }
        this.intoPackage = intoPackage;
    }

    public String getIntoPackage() {
        return this.intoPackage;
    }

    public String getBuilderName() {
        return this.builderName;
    }

    public void setBuilderName(String builderName) {
        if (builderName == null || builderName.trim().isEmpty()) {
            throw new AnalysisException("Value for attribute 'withName' must not be empty.");
        }
        this.builderName = builderName;
    }

    public void setBaseclassName(String baseclassName) {
        this.baseclassName = baseclassName;
    }

    public String getBaseclassName() {
        return this.baseclassName;
    }

    public String getBuilderInterfaceName() {
        return this.builderInterfaceName;
    }

    public void setBuilderInterfaceName(String builderInterfaceName) {
        this.builderInterfaceName = builderInterfaceName;
    }

    public String getSetterNamePattern() {
        return this.setterNamePattern;
    }

    public void setSetterNamePattern(String pattern) {
        this.setterNamePattern = pattern;
    }

    public String getOptionalClassname() {
        return this.optionalClassname;
    }

    public void setOptionalClassname(String optionalClassname) {
        this.optionalClassname = optionalClassname;
    }

    public String getStaticFactoryMethod() {
        return this.staticFactoryMethod;
    }

    public void setStaticFactoryMethod(String staticFactoryMethod) {
        this.staticFactoryMethod = staticFactoryMethod;
    }

    public Visibility getConstructor() {
        return this.constructor;
    }

    public void setConstructor(Visibility constructor) {
        this.constructor = constructor;
    }

    public List<PropertyPattern> getExcludeProperties() {
        return this.excludeProperties;
    }

    public void setExcludeProperties(List<PropertyPattern> excludeProperties) {
        this.excludeProperties = excludeProperties;
    }

    public List<PropertyPattern> getIncludeProperties() {
        return this.includeProperties;
    }

    public void setIncludeProperties(List<PropertyPattern> includeProperties) {
        this.includeProperties = includeProperties;
    }

    public String toString() {
        return "Directives [generateCopyMethod=" + this.generateCopyMethod + ", copyMethodName=" + this.copyMethodName + ", intoPackage=" + this.intoPackage + ", builderName=" + this.builderName + ", baseclassName=" + this.baseclassName + ", builderInterfaceName=" + this.builderInterfaceName + ", generateBuilderProperties=" + this.generateBuilderProperties + ", generationGap=" + this.generationGap + ", setterNamePattern=" + this.setterNamePattern + ", staticFactoryMethod=" + this.staticFactoryMethod + ", constructor=" + (Object)((Object)this.constructor) + ", validatorClassname=" + this.validatorClassname + ", optionalClassname=" + this.optionalClassname + ", includeProperties=" + this.includeProperties + ", excludeProperties=" + this.excludeProperties + "]";
    }
}

