/*
 * Decompiled with CFR 0.152.
 */
package net.karneim.pojobuilder.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.karneim.pojobuilder.model.TypeM;

public class ImportTypesM {
    private final Set<TypeM> types = new HashSet<TypeM>();
    private final SortedSet<String> classnames = new TreeSet<String>();
    private final Set<String> simpleNames = new HashSet<String>();

    public void add(Class<?> aClass) {
        this.add(new TypeM(aClass));
    }

    public boolean add(TypeM type) {
        if (!this.simpleNames.contains(type.getSimpleName())) {
            this.types.add(type);
            if (!type.isTypeVariable() && !type.isPrimitive()) {
                this.classnames.add(type.getName());
            }
            this.simpleNames.add(type.getSimpleName());
            return true;
        }
        return false;
    }

    public void remove(TypeM type) {
        this.types.remove(type);
        this.classnames.remove(type.getName());
        this.simpleNames.remove(type.getSimpleName());
    }

    public SortedSet<String> getSortedDistinctClassnames() {
        return this.classnames;
    }

    public void removePackage(String packageName) {
        for (TypeM type : new ArrayList<TypeM>(this.types)) {
            if (!type.isInPackage(packageName)) continue;
            this.remove(type);
        }
    }

    public String getCompressedTypeName(TypeM type) {
        this.add(type);
        if (this.classnames.contains(type.getName())) {
            return type.getSimpleName();
        }
        return type.getName();
    }
}

