/*
 * Decompiled with CFR 0.152.
 */
package net.karneim.pojobuilder.model;

import java.util.Set;
import javax.lang.model.element.Modifier;
import net.karneim.pojobuilder.model.TypeM;

public class MethodM {
    private String name;
    private Set<Modifier> modifiers;
    private TypeM declaringClass;

    public MethodM(String name, Set<Modifier> modifiers) {
        this.name = name;
        this.modifiers = modifiers;
    }

    public String getName() {
        return this.name;
    }

    public Set<Modifier> getModifiers() {
        return this.modifiers;
    }

    public TypeM getDeclaringClass() {
        return this.declaringClass;
    }

    public MethodM declaredIn(TypeM type) {
        this.declaringClass = type;
        return this;
    }

    public boolean isAccessibleFor(TypeM accessingClass) {
        if (accessingClass == null) {
            throw new NullPointerException("accessingClass==null!");
        }
        if (this.declaringClass == null) {
            throw new IllegalStateException(String.format("Missing declaringClass in MethodM %s", this.name));
        }
        if (this.modifiers.contains((Object)Modifier.PRIVATE)) {
            return false;
        }
        if (this.modifiers.contains((Object)Modifier.PROTECTED)) {
            return accessingClass.isInPackage(this.declaringClass.getPackageName());
        }
        if (this.modifiers.contains((Object)Modifier.PUBLIC)) {
            return true;
        }
        return accessingClass.isInPackage(this.declaringClass.getPackageName());
    }

    public String toString() {
        return "MethodM [name=" + this.name + ", modifiers=" + this.modifiers + ", declaringClass=" + this.declaringClass + "]";
    }
}

