/*
 * Decompiled with CFR 0.152.
 */
package net.karneim.pojobuilder.model;

import net.karneim.pojobuilder.model.ImportTypesM;
import net.karneim.pojobuilder.model.TypeListM;

public class TypeM {
    private final String packageName;
    private final String simpleName;
    private final String simpleNames;
    private final String name;
    private final TypeListM typeParameters = new TypeListM(new TypeM[0]);

    protected TypeM(String name) {
        this("", name);
    }

    public TypeM(String packageName, String simpleNames) {
        if (packageName == null) {
            packageName = "";
        }
        this.packageName = packageName;
        this.simpleNames = simpleNames;
        this.simpleName = simpleNames.substring(simpleNames.lastIndexOf(46) + 1);
        this.name = packageName.isEmpty() ? simpleNames : packageName + "." + simpleNames;
    }

    public TypeM(Class<?> aClass) {
        this(aClass.getPackage().getName(), aClass.getSimpleName());
    }

    public TypeM withTypeParameter(TypeM ... params) {
        for (TypeM p : params) {
            this.typeParameters.add(p);
        }
        return this;
    }

    public TypeListM getTypeParameters() {
        return this.typeParameters;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public String getSimpleNames() {
        return this.simpleNames;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isTypeVariable() {
        return false;
    }

    public boolean isArrayType() {
        return false;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public boolean isGeneric() {
        return !this.typeParameters.isEmpty();
    }

    public String getGenericTypeDefinition() {
        if (!this.isGeneric()) {
            return this.name;
        }
        return String.format("%s<%s>", this.name, this.typeParameters.toParameterString());
    }

    public String getGenericType() {
        if (!this.isGeneric()) {
            return this.name;
        }
        return String.format("%s<%s>", this.name, this.typeParameters.toArgumentString());
    }

    public ImportTypesM addToImportTypes(ImportTypesM result) {
        result.add(this);
        this.typeParameters.addToImportTypes(result);
        return result;
    }

    public boolean isInPackage(String packageName) {
        return packageName == null && this.packageName.isEmpty() || packageName.equals(this.packageName);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypeM other = (TypeM)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.typeParameters == null ? other.typeParameters != null : !this.typeParameters.equals(other.typeParameters));
    }

    public String toString() {
        return "TypeM [getGenericTypeDefinition()=" + this.getGenericTypeDefinition() + "]";
    }
}

