/*
 * Decompiled with CFR 0.152.
 */
package net.liftweb.json;

import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import net.liftweb.json.JsonAST;
import net.liftweb.json.JsonParser;
import net.liftweb.json.JsonParser$CloseArr$;
import net.liftweb.json.JsonParser$CloseObj$;
import net.liftweb.json.JsonParser$End$;
import net.liftweb.json.JsonParser$NullVal$;
import net.liftweb.json.JsonParser$OpenArr$;
import net.liftweb.json.JsonParser$OpenObj$;
import net.liftweb.json.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

public final class JsonParser$ {
    public static JsonParser$ MODULE$;
    private final BigDecimal BrokenDouble;
    private final Function1<JsonParser.Parser, JsonAST.JValue> astParser;
    private final char net$liftweb$json$JsonParser$$EOF;

    static {
        new JsonParser$();
    }

    public JsonAST.JValue parse(String s) {
        return this.parse(new JsonParser.Buffer(new StringReader(s), false));
    }

    public JsonAST.JValue parse(Reader s, boolean closeAutomatically) {
        return this.parse(new JsonParser.Buffer(s, closeAutomatically));
    }

    public Option<JsonAST.JValue> parseOpt(String s) {
        Option<JsonAST.JValue> option;
        try {
            option = this.parse(s).toOpt();
        }
        catch (Exception e) {
            option = None$.MODULE$;
        }
        return option;
    }

    public Option<JsonAST.JValue> parseOpt(Reader s, boolean closeAutomatically) {
        Option<JsonAST.JValue> option;
        try {
            option = this.parse(s, closeAutomatically).toOpt();
        }
        catch (Exception e) {
            option = None$.MODULE$;
        }
        return option;
    }

    public <A> A parse(String s, Function1<JsonParser.Parser, A> p) {
        return this.parse((Reader)new StringReader(s), p);
    }

    public <A> A parse(Reader s, Function1<JsonParser.Parser, A> p) {
        return (A)p.apply((Object)new JsonParser.Parser(new JsonParser.Buffer(s, false)));
    }

    private JsonAST.JValue parse(JsonParser.Buffer buf) {
        JsonAST.JValue jValue;
        try {
            try {
                jValue = (JsonAST.JValue)this.astParser().apply((Object)new JsonParser.Parser(buf));
            }
            catch (JsonParser.ParseException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JsonParser.ParseException("parsing failed", e);
            }
        }
        finally {
            buf.release();
        }
        return jValue;
    }

    public boolean parse$default$2() {
        return true;
    }

    public boolean parseOpt$default$2() {
        return true;
    }

    public String unquote(String string) {
        return this.unquote(new JsonParser.Buffer(new StringReader(string), false));
    }

    public String unquote(JsonParser.Buffer buf) {
        buf.eofIsFailure_$eq(true);
        buf.mark();
        char c = buf.next();
        while (c != '\"') {
            if (c == '\\') {
                String s = JsonParser$.unquote0$1(buf, buf.substring());
                buf.eofIsFailure_$eq(false);
                return s;
            }
            c = buf.next();
        }
        buf.eofIsFailure_$eq(false);
        return buf.substring();
    }

    private BigDecimal BrokenDouble() {
        return this.BrokenDouble;
    }

    public double parseDouble(String s) {
        BigDecimal d;
        BigDecimal bigDecimal = d = scala.package$.MODULE$.BigDecimal().apply(s);
        BigDecimal bigDecimal2 = this.BrokenDouble();
        if (!(bigDecimal != null ? !bigDecimal.equals(bigDecimal2) : bigDecimal2 != null)) {
            throw scala.sys.package$.MODULE$.error("Error parsing 2.2250738585072012e-308");
        }
        return d.doubleValue();
    }

    private Function1<JsonParser.Parser, JsonAST.JValue> astParser() {
        return this.astParser;
    }

    public char net$liftweb$json$JsonParser$$EOF() {
        return this.net$liftweb$json$JsonParser$$EOF;
    }

    private static final String unquote0$1(JsonParser.Buffer buf, String base) {
        StringBuilder s = new StringBuilder(base);
        char c = '\\';
        while (c != '\"') {
            StringBuilder stringBuilder;
            if (c == '\\') {
                char c2 = buf.next();
                switch (c2) {
                    case '\"': {
                        stringBuilder = s.append('\"');
                        break;
                    }
                    case '\\': {
                        stringBuilder = s.append('\\');
                        break;
                    }
                    case '/': {
                        stringBuilder = s.append('/');
                        break;
                    }
                    case 'b': {
                        stringBuilder = s.append('\b');
                        break;
                    }
                    case 'f': {
                        stringBuilder = s.append('\f');
                        break;
                    }
                    case 'n': {
                        stringBuilder = s.append('\n');
                        break;
                    }
                    case 'r': {
                        stringBuilder = s.append('\r');
                        break;
                    }
                    case 't': {
                        stringBuilder = s.append('\t');
                        break;
                    }
                    case 'u': {
                        char[] chars = new char[]{buf.next(), buf.next(), buf.next(), buf.next()};
                        int codePoint = Integer.parseInt(new String(chars), 16);
                        stringBuilder = s.appendCodePoint(codePoint);
                        break;
                    }
                    default: {
                        stringBuilder = s.append('\\');
                        break;
                    }
                }
            } else {
                stringBuilder = s.append(c);
            }
            c = buf.next();
        }
        return s.toString();
    }

    private static final JsonAST.JValue reverse$1(JsonAST.JValue v2) {
        JsonAST.JValue jValue;
        JsonAST.JValue jValue2 = v2;
        if (jValue2 instanceof JsonAST.JObject) {
            JsonAST.JObject jObject = (JsonAST.JObject)jValue2;
            List<JsonAST.JField> l = jObject.obj();
            jValue = package$.MODULE$.JObject().apply((List<JsonAST.JField>)((List)l.map((Function1 & Serializable & scala.Serializable)field -> {
                JsonAST.JValue x$11 = JsonParser$.reverse$1(field.value());
                String x$12 = field.copy$default$1();
                return field.copy(x$12, x$11);
            }, List$.MODULE$.canBuildFrom())).reverse());
        } else if (jValue2 instanceof JsonAST.JArray) {
            JsonAST.JArray jArray = (JsonAST.JArray)jValue2;
            List<JsonAST.JValue> l = jArray.arr();
            jValue = package$.MODULE$.JArray().apply((List<JsonAST.JValue>)((List)l.map((Function1 & Serializable & scala.Serializable)v -> JsonParser$.reverse$1(v), List$.MODULE$.canBuildFrom())).reverse());
        } else {
            jValue = jValue2;
        }
        return jValue;
    }

    private static final JsonAST.JValue toJValue$1(Object x, JsonParser.Parser p$1) {
        JsonAST.JValue jValue;
        Object object = x;
        if (!(object instanceof JsonAST.JValue)) {
            throw p$1.fail("unexpected field " + x);
        }
        JsonAST.JValue jValue2 = jValue = (JsonAST.JValue)object;
        return jValue2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final void closeBlock$1(Object v, JsonParser.ValStack vals$1, ObjectRef root$1, JsonParser.Parser p$1) {
        Object a;
        Object o;
        boolean bl = false;
        Some some = null;
        Option<Object> option = vals$1.peekOption();
        if (option instanceof Some) {
            JsonAST.JField jField;
            String name;
            bl = true;
            some = (Some)option;
            Object object = some.value();
            if (object instanceof JsonAST.JField && (name = (jField = (JsonAST.JField)object).name()) != null) {
                String string = name;
                vals$1.pop(JsonAST.JField.class);
                JsonAST.JObject obj = vals$1.peek(JsonAST.JObject.class);
                JsonAST.JField jField2 = package$.MODULE$.JField().apply(string, JsonParser$.toJValue$1(v, p$1));
                vals$1.replace(package$.MODULE$.JObject().apply((List<JsonAST.JField>)obj.obj().$colon$colon((Object)jField2)));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (bl && (o = some.value()) instanceof JsonAST.JObject) {
            JsonAST.JObject jObject = (JsonAST.JObject)o;
            JsonAST.JField jField = vals$1.peek(JsonAST.JField.class);
            vals$1.replace(package$.MODULE$.JObject().apply((List<JsonAST.JField>)jObject.obj().$colon$colon((Object)jField)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (bl && (a = some.value()) instanceof JsonAST.JArray) {
            JsonAST.JArray jArray = (JsonAST.JArray)a;
            JsonAST.JValue jValue = JsonParser$.toJValue$1(v, p$1);
            vals$1.replace(package$.MODULE$.JArray().apply((List<JsonAST.JValue>)jArray.arr().$colon$colon((Object)jValue)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (bl) {
            Object x = some.value();
            throw p$1.fail("expected field, array or object but got " + x);
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        root$1.elem = new Some((Object)JsonParser$.reverse$1(JsonParser$.toJValue$1(v, p$1)));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void newValue$1(JsonAST.JValue v, JsonParser.ValStack vals$1, ObjectRef root$1, JsonParser.Parser p$1) {
        if (!vals$1.isEmpty()) {
            Object object = vals$1.peekAny();
            if (object instanceof JsonAST.JField) {
                JsonAST.JField jField = (JsonAST.JField)object;
                String name = jField.name();
                vals$1.pop(JsonAST.JField.class);
                JsonAST.JObject obj = vals$1.peek(JsonAST.JObject.class);
                JsonAST.JField jField2 = package$.MODULE$.JField().apply(name, v);
                vals$1.replace(package$.MODULE$.JObject().apply((List<JsonAST.JField>)obj.obj().$colon$colon((Object)jField2)));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            } else {
                if (!(object instanceof JsonAST.JArray)) throw p$1.fail("expected field or array but got " + object);
                JsonAST.JArray jArray = (JsonAST.JArray)object;
                JsonAST.JValue jValue = v;
                vals$1.replace(package$.MODULE$.JArray().apply((List<JsonAST.JValue>)jArray.arr().$colon$colon((Object)jValue)));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        } else {
            vals$1.push(v);
            root$1.elem = new Some((Object)v);
        }
    }

    private JsonParser$() {
        MODULE$ = this;
        this.BrokenDouble = scala.package$.MODULE$.BigDecimal().apply("2.2250738585072012e-308");
        this.astParser = (Function1 & Serializable & scala.Serializable)p -> {
            JsonParser$End$ jsonParser$End$;
            JsonParser.Token token;
            JsonParser.ValStack vals = new JsonParser.ValStack((JsonParser.Parser)p);
            JsonParser.Token token2 = null;
            ObjectRef root = ObjectRef.create((Object)None$.MODULE$);
            do {
                BoxedUnit boxedUnit;
                JsonParser.Token token3;
                if (JsonParser$OpenObj$.MODULE$.equals(token3 = (token2 = p.nextToken()))) {
                    vals.push(package$.MODULE$.JObject().apply((List<JsonAST.JField>)Nil$.MODULE$));
                    boxedUnit = BoxedUnit.UNIT;
                } else if (token3 instanceof JsonParser.FieldStart) {
                    JsonParser.FieldStart fieldStart = (JsonParser.FieldStart)token3;
                    String name = fieldStart.name();
                    vals.push(package$.MODULE$.JField().apply(name, null));
                    boxedUnit = BoxedUnit.UNIT;
                } else if (token3 instanceof JsonParser.StringVal) {
                    JsonParser.StringVal stringVal = (JsonParser.StringVal)token3;
                    String x = stringVal.value();
                    JsonParser$.newValue$1(package$.MODULE$.JString().apply(x), vals, root, p);
                    boxedUnit = BoxedUnit.UNIT;
                } else if (token3 instanceof JsonParser.IntVal) {
                    JsonParser.IntVal intVal = (JsonParser.IntVal)token3;
                    BigInt x = intVal.value();
                    JsonParser$.newValue$1(package$.MODULE$.JInt().apply(x), vals, root, p);
                    boxedUnit = BoxedUnit.UNIT;
                } else if (token3 instanceof JsonParser.DoubleVal) {
                    JsonParser.DoubleVal doubleVal = (JsonParser.DoubleVal)token3;
                    double x = doubleVal.value();
                    JsonParser$.newValue$1(package$.MODULE$.JDouble().apply(x), vals, root, p);
                    boxedUnit = BoxedUnit.UNIT;
                } else if (token3 instanceof JsonParser.BoolVal) {
                    JsonParser.BoolVal boolVal = (JsonParser.BoolVal)token3;
                    boolean x = boolVal.value();
                    JsonParser$.newValue$1(package$.MODULE$.JBool().apply(x), vals, root, p);
                    boxedUnit = BoxedUnit.UNIT;
                } else if (JsonParser$NullVal$.MODULE$.equals(token3)) {
                    JsonParser$.newValue$1(package$.MODULE$.JNull(), vals, root, p);
                    boxedUnit = BoxedUnit.UNIT;
                } else if (JsonParser$CloseObj$.MODULE$.equals(token3)) {
                    JsonParser$.closeBlock$1(vals.popAny(), vals, root, p);
                    boxedUnit = BoxedUnit.UNIT;
                } else if (JsonParser$OpenArr$.MODULE$.equals(token3)) {
                    vals.push(package$.MODULE$.JArray().apply((List<JsonAST.JValue>)Nil$.MODULE$));
                    boxedUnit = BoxedUnit.UNIT;
                } else if (JsonParser$CloseArr$.MODULE$.equals(token3)) {
                    JsonParser$.closeBlock$1(vals.pop(JsonAST.JArray.class), vals, root, p);
                    boxedUnit = BoxedUnit.UNIT;
                } else if (JsonParser$End$.MODULE$.equals(token3)) {
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)token3);
                }
                token = token2;
                jsonParser$End$ = JsonParser$End$.MODULE$;
            } while (token == null ? jsonParser$End$ != null : !token.equals(jsonParser$End$));
            return (JsonAST.JValue)((Option)root.elem).getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.JNothing());
        };
        this.net$liftweb$json$JsonParser$$EOF = (char)-1;
    }
}

