/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.json;

import com.googlecode.totallylazy.Function1;
import com.googlecode.totallylazy.Option;
import com.googlecode.totallylazy.Sequence;
import com.googlecode.totallylazy.Sequences;
import java.util.ArrayList;
import java.util.List;
import net.masterthought.cucumber.ConfigurationOptions;
import net.masterthought.cucumber.json.Step;
import net.masterthought.cucumber.json.Tag;
import net.masterthought.cucumber.util.Status;
import net.masterthought.cucumber.util.Util;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class Element {
    private static final String BACKGROUND_KEYWORD = "Background";
    private String name;
    private String description;
    private String keyword;
    private Step[] steps;
    private Tag[] tags;

    public Sequence<Step> getSteps() {
        return Sequences.sequence((Object[])((Object[])Option.option((Object)this.steps).getOrElse((Object)new Step[0]))).realise();
    }

    public Sequence<Tag> getTags() {
        return Sequences.sequence((Object[])((Object[])Option.option((Object)this.tags).getOrElse((Object)new Tag[0]))).realise();
    }

    public Status getStatus() {
        boolean hasNoMissing;
        boolean hasNoSkipped;
        boolean hasNoFailed = this.getSteps().filter(Step.predicates.hasStatus(Status.FAILED)).isEmpty();
        if (!hasNoFailed) {
            return Status.FAILED;
        }
        ConfigurationOptions configuration = ConfigurationOptions.instance();
        if (configuration.skippedFailsBuild() && !(hasNoSkipped = this.getSteps().filter(Step.predicates.hasStatus(Status.SKIPPED)).isEmpty())) {
            return Status.FAILED;
        }
        if (configuration.pendingFailsBuild() && !(hasNoSkipped = this.getSteps().filter(Step.predicates.hasStatus(Status.PENDING)).isEmpty())) {
            return Status.FAILED;
        }
        if (configuration.undefinedFailsBuild() && !(hasNoSkipped = this.getSteps().filter(Step.predicates.hasStatus(Status.UNDEFINED)).isEmpty())) {
            return Status.FAILED;
        }
        if (configuration.missingFailsBuild() && !(hasNoMissing = this.getSteps().filter(Step.predicates.hasStatus(Status.MISSING)).isEmpty())) {
            return Status.FAILED;
        }
        return Status.PASSED;
    }

    public String getRawName() {
        return this.name;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getName() {
        ArrayList<String> contentString = new ArrayList<String>();
        if (Util.itemExists(this.keyword)) {
            contentString.add("<span class=\"scenario-keyword\">" + StringEscapeUtils.escapeHtml((String)this.keyword) + ": </span>");
        }
        if (Util.itemExists(this.name)) {
            contentString.add("<span class=\"scenario-name\">" + StringEscapeUtils.escapeHtml((String)this.name) + "</span>");
        }
        return Util.itemExists(contentString) ? this.getStatus().toHtmlClass() + StringUtils.join((Object[])contentString.toArray(), (String)" ") + "</div>" : "";
    }

    public Sequence<String> getTagList() {
        return this.processTags();
    }

    public boolean hasTags() {
        return Util.itemExists(this.tags);
    }

    public boolean hasSteps() {
        return !this.getSteps().isEmpty();
    }

    private Sequence<String> processTags() {
        return this.getTags().map(Tag.functions.getName());
    }

    public boolean isBackground() {
        return this.keyword.equals(BACKGROUND_KEYWORD);
    }

    public String getTagsList() {
        String result = "<div class=\"feature-tags\"></div>";
        if (Util.itemExists(this.tags)) {
            List str = this.getTagList().toList();
            ArrayList<String> tagList = new ArrayList<String>();
            for (String s : str) {
                String link = s.replace("@", "").trim() + ".html";
                String ref = "<a href=\"" + link + "\">" + s + "</a>";
                tagList.add(ref);
            }
            result = "<div class=\"feature-tags\">" + StringUtils.join((Object[])tagList.toArray(), (String)",") + "</div>";
        }
        return result;
    }

    public static class Functions {
        public static Function1<Element, Status> status() {
            return new Function1<Element, Status>(){

                public Status call(Element element) throws Exception {
                    return element.getStatus();
                }
            };
        }
    }
}

