/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.masterthought.cucumber.json.Element;
import net.masterthought.cucumber.json.Feature;
import net.masterthought.cucumber.json.Match;
import net.masterthought.cucumber.json.Result;
import net.masterthought.cucumber.json.Step;
import net.masterthought.cucumber.json.Tag;
import net.masterthought.cucumber.json.support.ResultsWithMatch;
import net.masterthought.cucumber.json.support.Status;
import net.masterthought.cucumber.json.support.StatusCounter;
import net.masterthought.cucumber.json.support.StepObject;
import net.masterthought.cucumber.json.support.TagObject;
import net.masterthought.cucumber.reports.OverviewReport;
import net.masterthought.cucumber.reports.Reportable;
import org.apache.commons.lang.StringUtils;

public class ReportResult {
    private final List<Feature> allFeatures = new ArrayList<Feature>();
    private final Map<String, TagObject> allTags = new TreeMap<String, TagObject>();
    private final Map<String, StepObject> allSteps = new TreeMap<String, StepObject>();
    private final StatusCounter featureCounter = new StatusCounter();
    private final String buildTime;
    private final OverviewReport featuresReport = new OverviewReport("Features");
    private final OverviewReport tagsReport = new OverviewReport("Tags");

    public ReportResult(List<Feature> features) {
        this.buildTime = ReportResult.getCurrentTime();
        for (Feature feature : features) {
            this.processFeature(feature);
        }
    }

    public List<Feature> getAllFeatures() {
        return ReportResult.mapToSortedList(this.allFeatures);
    }

    public List<TagObject> getAllTags() {
        return ReportResult.mapToSortedList(this.allTags.values());
    }

    public List<StepObject> getAllSteps() {
        return ReportResult.mapToSortedList(this.allSteps.values());
    }

    public Reportable getFeatureReport() {
        return this.featuresReport;
    }

    public Reportable getTagReport() {
        return this.tagsReport;
    }

    public int getAllPassedFeatures() {
        return this.featureCounter.getValueFor(Status.PASSED);
    }

    public int getAllFailedFeatures() {
        return this.featureCounter.getValueFor(Status.FAILED);
    }

    public String getBuildTime() {
        return this.buildTime;
    }

    private void processFeature(Feature feature) {
        this.allFeatures.add(feature);
        for (Element element : feature.getElements()) {
            ResultsWithMatch[] steps;
            if (element.isScenario()) {
                this.featuresReport.incScenarioFor(element.getElementStatus());
                for (Tag tag : feature.getTags()) {
                    this.processTag(tag, element, feature.getStatus());
                }
            }
            for (Tag tag : element.getTags()) {
                this.processTag(tag, element, element.getElementStatus());
            }
            for (Step step : steps = element.getSteps()) {
                this.featuresReport.incStepsFor(step.getStatus());
                this.featuresReport.incDurationBy(step.getDuration());
            }
            this.countSteps(steps);
            this.countSteps(element.getBefore());
            this.countSteps(element.getAfter());
        }
        this.featureCounter.incrementFor(feature.getStatus());
    }

    private void processTag(Tag tag, Element element, Status status) {
        TagObject tagObject = this.addTagObject(tag.getName());
        if (tagObject.addElement(element)) {
            Step[] steps;
            this.tagsReport.incScenarioFor(status);
            for (Step step : steps = element.getSteps()) {
                this.tagsReport.incStepsFor(step.getStatus());
                this.tagsReport.incDurationBy(step.getDuration());
            }
        }
    }

    private void countSteps(ResultsWithMatch[] steps) {
        for (ResultsWithMatch step : steps) {
            String methodName;
            Match match = step.getMatch();
            if (match == null || StringUtils.isEmpty((String)(methodName = match.getLocation()))) continue;
            this.addNewStep(step.getResult(), methodName);
        }
    }

    private void addNewStep(Result result, String methodName) {
        StepObject stepObject = this.allSteps.get(methodName);
        if (stepObject == null) {
            stepObject = new StepObject(methodName);
        }
        if (result != null) {
            stepObject.addDuration(result.getDuration(), result.getStatus());
        } else {
            stepObject.addDuration(0L, Status.FAILED.name());
        }
        this.allSteps.put(methodName, stepObject);
    }

    private TagObject addTagObject(String name) {
        TagObject tagObject = this.allTags.get(name);
        if (tagObject == null) {
            tagObject = new TagObject(name);
            this.allTags.put(tagObject.getName(), tagObject);
        }
        return tagObject;
    }

    public static String getCurrentTime() {
        return new SimpleDateFormat("dd MMM yyyy, HH:mm").format(new Date());
    }

    private static <T extends Comparable<? super T>> List<T> mapToSortedList(Collection<T> values) {
        ArrayList<T> list = new ArrayList<T>(values);
        Collections.sort(list);
        return list;
    }
}

