/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.json.support;

import net.masterthought.cucumber.json.support.Status;
import net.masterthought.cucumber.json.support.StatusCounter;
import net.masterthought.cucumber.util.Util;
import org.apache.commons.lang.StringUtils;

public class StepObject
implements Comparable<StepObject> {
    public final String location;
    private long totalDuration;
    private int totalOccurrences;
    private final StatusCounter statusCounter = new StatusCounter();

    public StepObject(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public void addDuration(long duration, String status) {
        this.totalDuration += duration;
        ++this.totalOccurrences;
        this.statusCounter.incrementFor(Status.toStatus(status));
    }

    public long getDurations() {
        return this.totalDuration;
    }

    public String getTotalFormattedDuration() {
        return Util.formatDuration(this.totalDuration);
    }

    public long getAverageDuration() {
        return this.totalDuration / (long)this.totalOccurrences;
    }

    public String getAverageFormattedDuration() {
        return Util.formatDuration(this.getAverageDuration());
    }

    public int getTotalOccurrences() {
        return this.totalOccurrences;
    }

    public String getPercentageResult() {
        int total = 0;
        for (Status status : Status.values()) {
            total += this.statusCounter.getValueFor(status);
        }
        if (total == 0) {
            return Util.PERCENT_FORMATTER.format(0L);
        }
        return Util.PERCENT_FORMATTER.format(1.0f * (float)this.statusCounter.getValueFor(Status.PASSED) / (float)total);
    }

    public Status getStatus() {
        return this.statusCounter.getFinalStatus();
    }

    @Override
    public int compareTo(StepObject o) {
        if (StringUtils.isEmpty((String)this.location)) {
            return -1;
        }
        if (StringUtils.isEmpty((String)o.getLocation())) {
            return 1;
        }
        return Integer.signum(this.location.compareTo(o.getLocation()));
    }
}

