/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.masterthought.cucumber.Reportable;
import net.masterthought.cucumber.generators.OverviewReport;
import net.masterthought.cucumber.json.Element;
import net.masterthought.cucumber.json.Feature;
import net.masterthought.cucumber.json.Match;
import net.masterthought.cucumber.json.Result;
import net.masterthought.cucumber.json.Step;
import net.masterthought.cucumber.json.Tag;
import net.masterthought.cucumber.json.support.Resultsable;
import net.masterthought.cucumber.json.support.Status;
import net.masterthought.cucumber.json.support.StepObject;
import net.masterthought.cucumber.json.support.TagObject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;

public class ReportResult {
    private final List<Feature> allFeatures = new ArrayList<Feature>();
    private final Map<String, TagObject> allTags = new TreeMap<String, TagObject>();
    private final Map<String, StepObject> allSteps = new TreeMap<String, StepObject>();
    private final String buildTime;
    private final OverviewReport featuresReport = new OverviewReport();
    private final OverviewReport tagsReport = new OverviewReport();

    public ReportResult(List<Feature> features) {
        this.buildTime = ReportResult.getCurrentTime();
        for (Feature feature : features) {
            this.processFeature(feature);
        }
    }

    public List<Feature> getAllFeatures() {
        return ReportResult.toSortedList(this.allFeatures);
    }

    public List<TagObject> getAllTags() {
        return ReportResult.toSortedList(this.allTags.values());
    }

    public List<StepObject> getAllSteps() {
        return ReportResult.toSortedList(this.allSteps.values());
    }

    private static <T extends Comparable<? super T>> List<T> toSortedList(Collection<T> values) {
        ArrayList<T> list = new ArrayList<T>(values);
        Collections.sort(list);
        return list;
    }

    public Reportable getFeatureReport() {
        return this.featuresReport;
    }

    public Reportable getTagReport() {
        return this.tagsReport;
    }

    public String getBuildTime() {
        return this.buildTime;
    }

    private void processFeature(Feature feature) {
        this.allFeatures.add(feature);
        for (Element element : feature.getElements()) {
            Resultsable[] steps;
            if (element.isScenario()) {
                this.featuresReport.incScenarioFor(element.getStatus());
                for (Tag tag : feature.getTags()) {
                    this.processTag(tag, element, feature.getStatus());
                }
            }
            for (Tag tag : element.getTags()) {
                if (ArrayUtils.contains((Object[])feature.getTags(), (Object)tag)) continue;
                this.processTag(tag, element, element.getStatus());
            }
            for (Step step : steps = element.getSteps()) {
                this.featuresReport.incStepsFor(step.getResult().getStatus());
                this.featuresReport.incDurationBy(step.getDuration());
            }
            this.countSteps(steps);
            this.countSteps(element.getBefore());
            this.countSteps(element.getAfter());
        }
        this.featuresReport.incFeaturesFor(feature.getStatus());
    }

    private void processTag(Tag tag, Element element, Status status) {
        TagObject tagObject = this.addTagObject(tag.getName());
        if (tagObject.addElement(element)) {
            Step[] steps;
            this.tagsReport.incScenarioFor(status);
            for (Step step : steps = element.getSteps()) {
                this.tagsReport.incStepsFor(step.getResult().getStatus());
                this.tagsReport.incDurationBy(step.getDuration());
            }
        }
    }

    private void countSteps(Resultsable[] steps) {
        for (Resultsable step : steps) {
            String methodName;
            Match match = step.getMatch();
            if (match == null || StringUtils.isEmpty((String)(methodName = match.getLocation()))) continue;
            this.addNewStep(step.getResult(), methodName);
        }
    }

    private void addNewStep(Result result, String methodName) {
        StepObject stepObject = this.allSteps.get(methodName);
        if (stepObject == null) {
            stepObject = new StepObject(methodName);
        }
        stepObject.addDuration(result.getDuration(), result.getStatus());
        this.allSteps.put(methodName, stepObject);
    }

    private TagObject addTagObject(String name) {
        TagObject tagObject = this.allTags.get(name);
        if (tagObject == null) {
            tagObject = new TagObject(name);
            this.allTags.put(tagObject.getName(), tagObject);
        }
        return tagObject;
    }

    public static String getCurrentTime() {
        return new SimpleDateFormat("dd MMM yyyy, HH:mm").format(new Date());
    }
}

