/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.json;

import net.masterthought.cucumber.json.Feature;
import net.masterthought.cucumber.json.Hook;
import net.masterthought.cucumber.json.Step;
import net.masterthought.cucumber.json.Tag;
import net.masterthought.cucumber.json.support.Status;
import net.masterthought.cucumber.json.support.StatusCounter;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class Element {
    private final String name;
    private final String type;
    private final String description;
    private final String keyword;
    private final Step[] steps = new Step[0];
    private final Hook[] before = new Hook[0];
    private final Hook[] after = new Hook[0];
    private final Tag[] tags = new Tag[0];
    private static final String SCENARIO_TYPE = "scenario";
    private Status elementStatus;
    private Status beforeStatus;
    private Status afterStatus;
    private Status stepsStatus;
    private Feature feature;

    public Element() {
        this.name = null;
        this.type = null;
        this.description = null;
        this.keyword = null;
    }

    public Step[] getSteps() {
        return this.steps;
    }

    public Hook[] getBefore() {
        return this.before;
    }

    public Hook[] getAfter() {
        return this.after;
    }

    public Tag[] getTags() {
        return this.tags;
    }

    public Status getStatus() {
        return this.elementStatus;
    }

    public Status getBeforeStatus() {
        return this.beforeStatus;
    }

    public Status getAfterStatus() {
        return this.afterStatus;
    }

    public Status getStepsStatus() {
        return this.stepsStatus;
    }

    public String getName() {
        return this.name;
    }

    public String getEscapedName() {
        return StringUtils.defaultString((String)StringEscapeUtils.escapeHtml((String)this.name));
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return StringUtils.defaultString((String)this.description);
    }

    public boolean isScenario() {
        return SCENARIO_TYPE.equals(this.type);
    }

    public Feature getFeature() {
        return this.feature;
    }

    public void setMetaData(Feature feature) {
        this.feature = feature;
        this.beforeStatus = this.calculateHookStatus(this.before);
        this.afterStatus = this.calculateHookStatus(this.after);
        this.stepsStatus = this.calculateStepsStatus();
        this.elementStatus = this.calculateElementStatus();
    }

    private Status calculateHookStatus(Hook[] hooks) {
        StatusCounter statusCounter = new StatusCounter();
        for (Hook hook : hooks) {
            statusCounter.incrementFor(hook.getResult().getStatus());
        }
        return statusCounter.getFinalStatus();
    }

    private Status calculateElementStatus() {
        StatusCounter statusCounter = new StatusCounter();
        statusCounter.incrementFor(this.stepsStatus);
        statusCounter.incrementFor(this.beforeStatus);
        statusCounter.incrementFor(this.afterStatus);
        return statusCounter.getFinalStatus();
    }

    private Status calculateStepsStatus() {
        StatusCounter statusCounter = new StatusCounter();
        for (Step step : this.steps) {
            statusCounter.incrementFor(step.getResult().getStatus());
        }
        return statusCounter.getFinalStatus();
    }
}

