/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.json.deserializers;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Base64;
import net.masterthought.cucumber.Configuration;
import net.masterthought.cucumber.ValidationException;
import net.masterthought.cucumber.json.Embedding;
import net.masterthought.cucumber.json.deserializers.CucumberJsonDeserializer;

public class EmbeddingDeserializer
extends CucumberJsonDeserializer<Embedding> {
    @Override
    public Embedding deserialize(JsonNode rootNode, Configuration configuration) {
        Embedding embedding;
        String data = rootNode.get("data").asText();
        String mimeType = this.findMimeType(rootNode);
        String encodedData = this.getBase64EncodedData(data);
        String nameField = "name";
        if (rootNode.has(nameField)) {
            String name = rootNode.get(nameField).asText();
            embedding = new Embedding(mimeType, encodedData, name);
        } else {
            embedding = new Embedding(mimeType, encodedData);
        }
        this.storeEmbedding(embedding, configuration.getEmbeddingDirectory());
        return embedding;
    }

    private String getBase64EncodedData(String data) {
        try {
            Base64.getDecoder().decode(data);
            return data;
        }
        catch (IllegalArgumentException e) {
            return new String(Base64.getEncoder().encode(data.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        }
    }

    private String findMimeType(JsonNode rootNode) {
        JsonNode media = rootNode.get("media");
        if (media != null) {
            return media.get("type").asText();
        }
        return rootNode.get("mime_type").asText();
    }

    private void storeEmbedding(Embedding embedding, File embeddingDirectory) {
        Path file = FileSystems.getDefault().getPath(embeddingDirectory.getAbsolutePath(), embedding.getFileId() + "." + embedding.getExtension());
        byte[] decodedData = Base64.getDecoder().decode(embedding.getData().getBytes(StandardCharsets.UTF_8));
        try {
            Files.write(file, decodedData, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new ValidationException(e);
        }
    }
}

