/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.mdiy.biz.impl;

import com.mingsoft.base.biz.impl.BaseBizImpl;
import com.mingsoft.base.dao.IBaseDao;
import com.mingsoft.mdiy.biz.IFormBiz;
import com.mingsoft.mdiy.dao.IFormDao;
import com.mingsoft.mdiy.dao.IFormFieldDao;
import com.mingsoft.mdiy.entity.FormEntity;
import com.mingsoft.mdiy.entity.FormFieldEntity;
import com.mingsoft.util.PageUtil;
import com.mingsoft.util.StringUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FormBizImpl
extends BaseBizImpl
implements IFormBiz {
    private static final String FORM_ID = "FROMID";
    private static final String DATE = "DATE";
    private static final String ID = "ID";
    @Autowired
    private IFormDao formDao;
    @Autowired
    private IFormFieldDao formFieldDao;

    protected IBaseDao getDao() {
        return this.formDao;
    }

    @Override
    public void saveDiyFormData(int formId, Map params) {
        FormEntity dfe = (FormEntity)this.formDao.getEntity(formId);
        if (dfe == null) {
            return;
        }
        String tableName = dfe.getFormTableName();
        List<FormFieldEntity> filedList = this.formFieldDao.queryByDiyFormId(formId);
        if (filedList == null) {
            return;
        }
        Map values = this.builderSqlMap(filedList, params);
        values.put(FORM_ID, formId);
        values.put(DATE, new Date());
        this.formFieldDao.insertBySQL(tableName, values);
    }

    @Override
    public Map queryDiyFormData(int diyFormId, int appId, PageUtil page) {
        FormEntity dfe = (FormEntity)this.formDao.getEntity(diyFormId);
        if (dfe != null) {
            List<FormFieldEntity> fieldList = this.formFieldDao.queryByDiyFormId(diyFormId);
            ArrayList fields = new ArrayList();
            for (int i = 0; i < fieldList.size(); ++i) {
                HashMap<String, String> field = new HashMap<String, String>();
                field.put(fieldList.get(i).getDiyFormFieldFieldName(), fieldList.get(i).getDiyFormFieldTipsName());
                fields.add(field);
            }
            HashMap<String, Integer> wheres = new HashMap<String, Integer>();
            wheres.put(FORM_ID, diyFormId);
            List list = this.formDao.queryBySQL(dfe.getFormTableName(), null, wheres, page.getPageSize() * page.getPageNo(), page.getPageSize(), ID);
            HashMap<String, List> r = new HashMap<String, List>();
            r.put("fields", fieldList);
            r.put("list", list);
            return r;
        }
        return null;
    }

    @Override
    public void deleteQueryDiyFormData(int id, int diyFormId) {
        FormEntity dfe = (FormEntity)this.formDao.getEntity(diyFormId);
        HashMap<String, Integer> wheres = new HashMap<String, Integer>();
        wheres.put(FORM_ID, diyFormId);
        wheres.put(ID, id);
        this.formDao.deleteBySQL(dfe.getFormTableName(), wheres);
    }

    @Override
    public int countDiyFormData(int diyFormId, int appId) {
        FormEntity dfe = (FormEntity)this.formDao.getEntity(diyFormId);
        HashMap<String, Integer> wheres = new HashMap<String, Integer>();
        wheres.put(FORM_ID, diyFormId);
        return this.formDao.countBySQL(dfe.getFormTableName(), wheres);
    }

    private Map builderSqlMap(List listField, Map params) {
        HashMap mapParams = new HashMap();
        for (int i = 0; i < listField.size(); ++i) {
            FormFieldEntity field = (FormFieldEntity)((Object)listField.get(i));
            String fieldName = field.getDiyFormFieldFieldName();
            if (StringUtil.isBlank(params.get(fieldName.toLowerCase()))) {
                mapParams.put(fieldName, null);
                continue;
            }
            mapParams.put(fieldName, params.get(fieldName.toLowerCase()));
        }
        return mapParams;
    }

    @Override
    public void createDiyFormTable(String table, Map<Object, List> fileds) {
        this.formDao.createDiyFormTable(table, fileds);
    }
}

