/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.affinity.impl;

import com.sun.jna.LastErrorException;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.LongByReference;
import java.util.BitSet;
import net.openhft.affinity.IAffinity;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum WindowsJNAAffinity implements IAffinity
{
    INSTANCE;

    public static final boolean LOADED;
    private static final Logger LOGGER;
    private static final ThreadLocal<BitSet> currentAffinity;
    private final ThreadLocal<Integer> THREAD_ID = new ThreadLocal();

    @Override
    public BitSet getAffinity() {
        BitSet bitSet = currentAffinity.get();
        if (bitSet != null) {
            return bitSet;
        }
        BitSet longs = this.getAffinity0();
        return longs != null ? longs : new BitSet();
    }

    @Override
    public void setAffinity(BitSet affinity) {
        WinDef.DWORD aff;
        CLibrary lib = CLibrary.INSTANCE;
        long[] longs = affinity.toLongArray();
        switch (longs.length) {
            case 0: {
                aff = new WinDef.DWORD(0L);
                break;
            }
            case 1: {
                aff = new WinDef.DWORD(longs[0]);
                break;
            }
            default: {
                throw new IllegalArgumentException("Windows API does not support more than 64 CPUs for thread affinity");
            }
        }
        int pid = this.getTid();
        try {
            lib.SetThreadAffinityMask(this.handle(pid), aff);
        }
        catch (LastErrorException e) {
            throw new IllegalStateException("SetThreadAffinityMask((" + pid + ") , &(" + affinity + ") ) errorNo=" + e.getErrorCode(), e);
        }
        BitSet affinity2 = this.getAffinity0();
        if (!affinity2.equals(affinity)) {
            LoggerFactory.getLogger(WindowsJNAAffinity.class).warn("Tried to set affinity to " + affinity + " but was " + affinity2 + " you may have in sufficient access rights");
        }
        currentAffinity.set((BitSet)affinity.clone());
    }

    @Nullable
    private BitSet getAffinity0() {
        CLibrary lib = CLibrary.INSTANCE;
        LongByReference cpuset1 = new LongByReference(0L);
        LongByReference cpuset2 = new LongByReference(0L);
        try {
            int ret = lib.GetProcessAffinityMask(this.handle(-1), (PointerType)cpuset1, (PointerType)cpuset2);
            if (ret <= 0) {
                throw new IllegalStateException("GetProcessAffinityMask(( -1 ), &(" + cpuset1 + "), &(" + cpuset2 + ") ) return " + ret);
            }
            long[] longs = new long[]{cpuset1.getValue()};
            return BitSet.valueOf(longs);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private WinNT.HANDLE handle(int pid) {
        return new WinNT.HANDLE(new Pointer((long)pid));
    }

    public int getTid() {
        CLibrary lib = CLibrary.INSTANCE;
        try {
            return lib.GetCurrentThread();
        }
        catch (LastErrorException e) {
            throw new IllegalStateException("GetCurrentThread( ) errorNo=" + e.getErrorCode(), e);
        }
    }

    @Override
    public int getCpu() {
        return -1;
    }

    @Override
    public int getProcessId() {
        return Kernel32.INSTANCE.GetCurrentProcessId();
    }

    @Override
    public int getThreadId() {
        Integer tid = this.THREAD_ID.get();
        if (tid == null) {
            tid = Kernel32.INSTANCE.GetCurrentThreadId();
            this.THREAD_ID.set(tid);
        }
        return tid;
    }

    static {
        LOGGER = LoggerFactory.getLogger(WindowsJNAAffinity.class);
        currentAffinity = new ThreadLocal();
        boolean loaded = false;
        try {
            INSTANCE.getAffinity();
            loaded = true;
        }
        catch (UnsatisfiedLinkError e) {
            LOGGER.warn("Unable to load jna library", (Throwable)e);
        }
        LOADED = loaded;
    }

    private static interface CLibrary
    extends Library {
        public static final CLibrary INSTANCE = (CLibrary)Native.load((String)"kernel32", CLibrary.class);

        public int GetProcessAffinityMask(WinNT.HANDLE var1, PointerType var2, PointerType var3) throws LastErrorException;

        public void SetThreadAffinityMask(WinNT.HANDLE var1, WinDef.DWORD var2) throws LastErrorException;

        public int GetCurrentThread() throws LastErrorException;
    }
}

