/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import net.ravendb.client.documents.DocumentStoreBase;
import net.ravendb.client.documents.IDocumentStore;
import net.ravendb.client.documents.identity.MultiDatabaseHiLoIdGenerator;
import net.ravendb.client.documents.operations.MaintenanceOperationExecutor;
import net.ravendb.client.documents.operations.OperationExecutor;
import net.ravendb.client.documents.session.DocumentSession;
import net.ravendb.client.documents.session.IDocumentSession;
import net.ravendb.client.documents.session.SessionOptions;
import net.ravendb.client.http.AggressiveCacheOptions;
import net.ravendb.client.http.RequestExecutor;
import net.ravendb.client.primitives.CleanCloseable;
import net.ravendb.client.primitives.EventArgs;
import net.ravendb.client.primitives.EventHandler;
import net.ravendb.client.primitives.EventHelper;
import net.ravendb.client.primitives.ExceptionsUtils;
import net.ravendb.client.primitives.VoidArgs;
import org.apache.commons.lang3.ObjectUtils;

public class DocumentStore
extends DocumentStoreBase {
    private final ConcurrentMap<String, RequestExecutor> requestExecutors = new ConcurrentSkipListMap<String, RequestExecutor>(String.CASE_INSENSITIVE_ORDER);
    private MultiDatabaseHiLoIdGenerator _multiDbHiLo;
    private MaintenanceOperationExecutor maintenanceOperationExecutor;
    private OperationExecutor operationExecutor;
    private String identifier;
    private boolean _aggressiveCachingUsed;
    private final List<EventHandler<VoidArgs>> afterDispose = new ArrayList<EventHandler<VoidArgs>>();

    public DocumentStore(String url, String database) {
        this.setUrls(new String[]{url});
        this.setDatabase(database);
    }

    public DocumentStore(String[] urls, String database) {
        this.setUrls(urls);
        this.setDatabase(database);
    }

    public DocumentStore() {
    }

    @Override
    public String getIdentifier() {
        if (this.identifier != null) {
            return this.identifier;
        }
        if (this.urls == null) {
            return null;
        }
        if (this.database != null) {
            return String.join((CharSequence)",", this.urls) + " (DB: " + this.database + ")";
        }
        return String.join((CharSequence)",", this.urls);
    }

    @Override
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public void close() {
        if (this._multiDbHiLo != null) {
            try {
                this._multiDbHiLo.returnUnusedRange();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.disposed = true;
        EventHelper.invoke(this.afterDispose, this, EventArgs.EMPTY);
        for (Map.Entry kvp : this.requestExecutors.entrySet()) {
            ((RequestExecutor)kvp.getValue()).close();
        }
    }

    @Override
    public IDocumentSession openSession() {
        return this.openSession(new SessionOptions());
    }

    @Override
    public IDocumentSession openSession(String database) {
        SessionOptions sessionOptions = new SessionOptions();
        sessionOptions.setDatabase(database);
        return this.openSession(sessionOptions);
    }

    @Override
    public IDocumentSession openSession(SessionOptions options) {
        this.assertInitialized();
        this.ensureNotClosed();
        UUID sessionId = UUID.randomUUID();
        String databaseName = (String)ObjectUtils.firstNonNull((Object[])new String[]{options.getDatabase(), this.getDatabase()});
        RequestExecutor requestExecutor = (RequestExecutor)ObjectUtils.firstNonNull((Object[])new RequestExecutor[]{options.getRequestExecutor(), this.getRequestExecutor(databaseName)});
        DocumentSession session = new DocumentSession(databaseName, this, sessionId, requestExecutor);
        this.registerEvents(session);
        return session;
    }

    @Override
    public RequestExecutor getRequestExecutor() {
        return this.getRequestExecutor(null);
    }

    @Override
    public RequestExecutor getRequestExecutor(String database) {
        RequestExecutor executor;
        this.assertInitialized();
        if (database == null) {
            database = this.getDatabase();
        }
        if ((executor = (RequestExecutor)this.requestExecutors.get(database)) != null) {
            return executor;
        }
        executor = !this.getConventions().isDisableTopologyUpdates() ? RequestExecutor.create(this.getUrls(), this.getDatabase(), this.getCertificate(), this.getConventions()) : RequestExecutor.createForSingleNodeWithConfigurationUpdates(this.getUrls()[0], this.getDatabase(), this.getCertificate(), this.getConventions());
        this.requestExecutors.put(database, executor);
        return executor;
    }

    @Override
    public IDocumentStore initialize() {
        if (this.initialized) {
            return this;
        }
        this.assertValidConfiguration();
        try {
            if (this.getConventions().getDocumentIdGenerator() == null) {
                MultiDatabaseHiLoIdGenerator generator;
                this._multiDbHiLo = generator = new MultiDatabaseHiLoIdGenerator(this, this.getConventions());
                this.getConventions().setDocumentIdGenerator(generator::generateDocumentId);
            }
            this.getConventions().freeze();
            this.initialized = true;
        }
        catch (Exception e) {
            this.close();
            throw ExceptionsUtils.unwrapException(e);
        }
        return this;
    }

    protected void assertValidConfiguration() {
        if (this.urls == null || this.urls.length == 0) {
            throw new IllegalArgumentException("Document store URLs cannot be empty");
        }
    }

    @Override
    public CleanCloseable disableAggressiveCaching() {
        return this.disableAggressiveCaching(null);
    }

    @Override
    public CleanCloseable disableAggressiveCaching(String databaseName) {
        this.assertInitialized();
        RequestExecutor re = this.getRequestExecutor((String)ObjectUtils.firstNonNull((Object[])new String[]{this.database, this.getDatabase()}));
        AggressiveCacheOptions old = re.AggressiveCaching.get();
        re.AggressiveCaching.set(null);
        return () -> re.AggressiveCaching.set(old);
    }

    @Override
    public void addAfterCloseListener(EventHandler<VoidArgs> event) {
        this.afterDispose.add(event);
    }

    @Override
    public void removeAfterCloseListener(EventHandler<VoidArgs> event) {
        this.afterDispose.remove(event);
    }

    @Override
    public MaintenanceOperationExecutor maintenance() {
        this.assertInitialized();
        if (this.maintenanceOperationExecutor == null) {
            this.maintenanceOperationExecutor = new MaintenanceOperationExecutor(this);
        }
        return this.maintenanceOperationExecutor;
    }

    @Override
    public OperationExecutor operations() {
        if (this.operationExecutor == null) {
            this.operationExecutor = new OperationExecutor(this);
        }
        return this.operationExecutor;
    }
}

