/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.commands;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import net.ravendb.client.documents.commands.GetDocumentsResult;
import net.ravendb.client.extensions.JsonExtensions;
import net.ravendb.client.http.RavenCommand;
import net.ravendb.client.http.ServerNode;
import net.ravendb.client.json.ContentProviderHttpEntity;
import net.ravendb.client.primitives.Reference;
import net.ravendb.client.util.UrlUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;

public class GetDocumentsCommand
extends RavenCommand<GetDocumentsResult> {
    private String _id;
    private String[] _ids;
    private String[] _includes;
    private boolean _metadataOnly;
    private String _startWith;
    private String _matches;
    private Integer _start;
    private Integer _pageSize;
    private String _exclude;
    private String _startAfter;

    public GetDocumentsCommand(int start, int pageSize) {
        super(GetDocumentsResult.class);
        this._start = start;
        this._pageSize = pageSize;
    }

    public GetDocumentsCommand(String id, String[] includes, boolean metadataOnly) {
        super(GetDocumentsResult.class);
        this._id = id;
        this._includes = includes;
        this._metadataOnly = metadataOnly;
    }

    public GetDocumentsCommand(String[] ids, String[] includes, boolean metadataOnly) {
        super(GetDocumentsResult.class);
        if (ids == null || ids.length == 0) {
            throw new IllegalArgumentException("Please supply at least one id");
        }
        this._ids = ids;
        this._includes = includes;
        this._metadataOnly = metadataOnly;
    }

    public GetDocumentsCommand(String startWith, String startAfter, String matches, String exclude, int start, int pageSize, boolean metadataOnly) {
        super(GetDocumentsResult.class);
        if (startWith == null) {
            throw new IllegalArgumentException("startWith cannot be null");
        }
        this._startWith = startWith;
        this._startAfter = startAfter;
        this._matches = matches;
        this._exclude = exclude;
        this._start = start;
        this._pageSize = pageSize;
        this._metadataOnly = metadataOnly;
    }

    @Override
    public HttpRequestBase createRequest(ServerNode node, Reference<String> url) {
        StringBuilder pathBuilder = new StringBuilder(node.getUrl());
        pathBuilder.append("/databases/").append(node.getDatabase()).append("/docs?");
        if (this._start != null) {
            pathBuilder.append("&start=").append(this._start);
        }
        if (this._pageSize != null) {
            pathBuilder.append("&pageSize=").append(this._pageSize);
        }
        if (this._metadataOnly) {
            pathBuilder.append("&metadataOnly=true");
        }
        if (this._startWith != null) {
            pathBuilder.append("&startsWith=");
            pathBuilder.append(UrlUtils.escapeDataString(this._startWith));
            if (this._matches != null) {
                pathBuilder.append("&matches=");
                pathBuilder.append(this._matches);
            }
            if (this._exclude != null) {
                pathBuilder.append("&exclude=");
                pathBuilder.append(this._exclude);
            }
            if (this._startAfter != null) {
                pathBuilder.append("&startAfter=");
                pathBuilder.append(this._startAfter);
            }
        }
        if (this._includes != null) {
            for (String include : this._includes) {
                pathBuilder.append("&include=");
                pathBuilder.append(include);
            }
        }
        HttpGet request = new HttpGet();
        if (this._id != null) {
            pathBuilder.append("&id=");
            pathBuilder.append(UrlUtils.escapeDataString(this._id));
        } else if (this._ids != null) {
            request = GetDocumentsCommand.prepareRequestWithMultipleIds(pathBuilder, (HttpRequestBase)request, this._ids);
        }
        url.value = pathBuilder.toString();
        return request;
    }

    public static HttpRequestBase prepareRequestWithMultipleIds(StringBuilder pathBuilder, HttpRequestBase request, String[] ids) {
        boolean isGet;
        LinkedHashSet uniqueIds = new LinkedHashSet();
        Collections.addAll(uniqueIds, ids);
        boolean bl = isGet = uniqueIds.stream().map(String::length).reduce((prev, current) -> prev + current).orElse(0) < 1024;
        if (isGet) {
            uniqueIds.forEach(x -> {
                if (x != null) {
                    pathBuilder.append("&id=");
                    pathBuilder.append(UrlUtils.escapeDataString(x));
                }
            });
            return new HttpGet();
        }
        HttpPost httpPost = new HttpPost();
        ObjectMapper mapper = JsonExtensions.getDefaultMapper();
        httpPost.setEntity((HttpEntity)new ContentProviderHttpEntity(outputStream -> {
            try (JsonGenerator generator = mapper.getFactory().createGenerator(outputStream);){
                generator.writeStartObject();
                generator.writeFieldName("Ids");
                generator.writeStartArray();
                for (String id : uniqueIds) {
                    generator.writeString(id);
                }
                generator.writeEndArray();
                generator.writeEndObject();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, ContentType.APPLICATION_JSON));
        return httpPost;
    }

    @Override
    public void setResponse(String response, boolean fromCache) throws IOException {
        if (response == null) {
            this.result = null;
            return;
        }
        this.result = this.mapper.readValue(response, this.resultClass);
    }

    @Override
    public boolean isReadRequest() {
        return true;
    }
}

