/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.commands;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import net.ravendb.client.documents.conventions.DocumentConventions;
import net.ravendb.client.extensions.JsonExtensions;
import net.ravendb.client.http.RavenCommand;
import net.ravendb.client.http.ServerNode;
import net.ravendb.client.primitives.Reference;
import net.ravendb.client.serverwide.operations.IMaintenanceOperation;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;

public class GetOperationStateOperation
implements IMaintenanceOperation<ObjectNode> {
    private final long _id;

    public GetOperationStateOperation(long id) {
        this._id = id;
    }

    @Override
    public RavenCommand<ObjectNode> getCommand(DocumentConventions conventions) {
        return new GetOperationStateCommand(DocumentConventions.defaultConventions, this._id);
    }

    public static class GetOperationStateCommand
    extends RavenCommand<ObjectNode> {
        private final DocumentConventions _conventions;
        private final long _id;

        @Override
        public boolean isReadRequest() {
            return true;
        }

        public GetOperationStateCommand(DocumentConventions conventions, long id) {
            super(ObjectNode.class);
            this._conventions = conventions;
            this._id = id;
        }

        @Override
        public HttpRequestBase createRequest(ServerNode node, Reference<String> url) {
            url.value = node.getUrl() + "/databases/" + node.getDatabase() + "/operations/state?id=" + this._id;
            return new HttpGet();
        }

        @Override
        public void setResponse(String response, boolean fromCache) throws IOException {
            if (response == null) {
                return;
            }
            ObjectNode node = (ObjectNode)JsonExtensions.getDefaultMapper().readTree(response);
            this.result = node;
        }
    }
}

