/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.commands;

import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import net.ravendb.client.http.RavenCommand;
import net.ravendb.client.http.ServerNode;
import net.ravendb.client.primitives.Reference;
import net.ravendb.client.util.UrlUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;

public class GetRevisionsCommand
extends RavenCommand<ArrayNode> {
    private String _id;
    private Integer _start;
    private Integer _pageSize;
    private boolean _metadataOnly;
    private String _changeVector;
    private String[] _changeVectors;

    public GetRevisionsCommand(String changeVector) {
        this(changeVector, false);
    }

    public GetRevisionsCommand(String changeVector, boolean metadataOnly) {
        super(ArrayNode.class);
        this._changeVector = changeVector;
        this._metadataOnly = metadataOnly;
    }

    public GetRevisionsCommand(String[] changeVectors) {
        this(changeVectors, false);
    }

    public GetRevisionsCommand(String[] changeVectors, boolean metadataOnly) {
        super(ArrayNode.class);
        this._changeVectors = changeVectors;
        this._metadataOnly = metadataOnly;
    }

    public GetRevisionsCommand(String id, Integer start, Integer pageSize) {
        this(id, start, pageSize, false);
    }

    public GetRevisionsCommand(String id, Integer start, Integer pageSize, boolean metadataOnly) {
        super(ArrayNode.class);
        if (id == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        this._id = id;
        this._start = start;
        this._pageSize = pageSize;
        this._metadataOnly = metadataOnly;
    }

    public String[] getChangeVectors() {
        return this._changeVectors;
    }

    @Override
    public HttpRequestBase createRequest(ServerNode node, Reference<String> url) {
        HttpGet request = new HttpGet();
        StringBuilder pathBuilder = new StringBuilder(node.getUrl()).append("/databases/").append(node.getDatabase()).append("/revisions?");
        if (this._id != null) {
            pathBuilder.append("&id=").append(UrlUtils.escapeDataString(this._id));
        } else if (this._changeVector != null) {
            pathBuilder.append("&changeVector=").append(UrlUtils.escapeDataString(this._changeVector));
        } else if (this._changeVectors != null) {
            for (String changeVector : this._changeVectors) {
                pathBuilder.append("&changeVector=").append(UrlUtils.escapeDataString(changeVector));
            }
        }
        if (this._start != null) {
            pathBuilder.append("&start=").append(this._start);
        }
        if (this._pageSize != null) {
            pathBuilder.append("&pageSize=").append(this._pageSize);
        }
        if (this._metadataOnly) {
            pathBuilder.append("&metadataOnly=true");
        }
        url.value = pathBuilder.toString();
        return request;
    }

    @Override
    public void setResponse(String response, boolean fromCache) throws IOException {
        if (response == null) {
            this.result = null;
        }
        this.result = (ArrayNode)this.mapper.readTree(response);
    }

    @Override
    public boolean isReadRequest() {
        return true;
    }
}

