/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.commands;

import net.ravendb.client.extensions.HttpExtensions;
import net.ravendb.client.http.HttpCache;
import net.ravendb.client.http.RavenCommand;
import net.ravendb.client.http.ResponseDisposeHandling;
import net.ravendb.client.http.ServerNode;
import net.ravendb.client.primitives.Reference;
import net.ravendb.client.util.UrlUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpRequestBase;

public class HeadDocumentCommand
extends RavenCommand<String> {
    private final String _id;
    private final String _changeVector;

    public HeadDocumentCommand(String id, String changeVector) {
        super(String.class);
        if (id == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        this._id = id;
        this._changeVector = changeVector;
    }

    @Override
    public boolean isReadRequest() {
        return false;
    }

    @Override
    public HttpRequestBase createRequest(ServerNode node, Reference<String> url) {
        url.value = node.getUrl() + "/databases/" + node.getDatabase() + "/docs?id=" + UrlUtils.escapeDataString(this._id);
        HttpHead request = new HttpHead();
        if (this._changeVector != null) {
            request.setHeader("If-None-Match", this._changeVector);
        }
        return request;
    }

    @Override
    public ResponseDisposeHandling processResponse(HttpCache cache, CloseableHttpResponse response, String url) {
        if (304 == response.getStatusLine().getStatusCode()) {
            this.result = this._changeVector;
            return ResponseDisposeHandling.AUTOMATIC;
        }
        if (response.getStatusLine().getStatusCode() == 404) {
            this.result = null;
            return ResponseDisposeHandling.AUTOMATIC;
        }
        this.result = HttpExtensions.getRequiredEtagHeader(response);
        return ResponseDisposeHandling.AUTOMATIC;
    }

    @Override
    public void setResponse(String response, boolean fromCache) {
        if (response != null) {
            HeadDocumentCommand.throwInvalidResponse();
        }
        this.result = null;
    }
}

