/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.commands;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import net.ravendb.client.http.RavenCommand;
import net.ravendb.client.http.ServerNode;
import net.ravendb.client.primitives.Reference;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;

public class NextIdentityForCommand
extends RavenCommand<Long> {
    private final String _id;

    public NextIdentityForCommand(String id) {
        super(Long.class);
        if (id == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        this._id = id;
    }

    @Override
    public boolean isReadRequest() {
        return false;
    }

    @Override
    public HttpRequestBase createRequest(ServerNode node, Reference<String> url) {
        NextIdentityForCommand.ensureIsNotNullOrString(this._id, "id");
        url.value = node.getUrl() + "/databases/" + node.getDatabase() + "/identity/next?name=" + this.urlEncode(this._id);
        return new HttpPost();
    }

    @Override
    public void setResponse(String response, boolean fromCache) throws IOException {
        JsonNode jsonNode;
        if (response == null) {
            NextIdentityForCommand.throwInvalidResponse();
        }
        if (!(jsonNode = this.mapper.readTree(response)).has("NewIdentityValue")) {
            NextIdentityForCommand.throwInvalidResponse();
        }
        this.result = jsonNode.get("NewIdentityValue").asLong();
    }
}

