/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.commands;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import net.ravendb.client.documents.conventions.DocumentConventions;
import net.ravendb.client.documents.queries.IndexQuery;
import net.ravendb.client.documents.queries.QueryResult;
import net.ravendb.client.extensions.JsonExtensions;
import net.ravendb.client.http.RavenCommand;
import net.ravendb.client.http.ServerNode;
import net.ravendb.client.json.ContentProviderHttpEntity;
import net.ravendb.client.primitives.Reference;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;

public class QueryCommand
extends RavenCommand<QueryResult> {
    private final DocumentConventions _conventions;
    private final IndexQuery _indexQuery;
    private final boolean _metadataOnly;
    private final boolean _indexEntriesOnly;

    public QueryCommand(DocumentConventions conventions, IndexQuery indexQuery, boolean metadataOnly, boolean indexEntriesOnly) {
        super(QueryResult.class);
        if (conventions == null) {
            throw new IllegalArgumentException("conventions cannot be null");
        }
        if (indexQuery == null) {
            throw new IllegalArgumentException("indexQuery cannot be null");
        }
        this._conventions = conventions;
        this._indexQuery = indexQuery;
        this._metadataOnly = metadataOnly;
        this._indexEntriesOnly = indexEntriesOnly;
    }

    @Override
    public HttpRequestBase createRequest(ServerNode node, Reference<String> url) {
        this.canCache = !this._indexQuery.isDisableCaching();
        this.canCacheAggressively = this.canCache && !this._indexQuery.isWaitForNonStaleResults();
        StringBuilder path = new StringBuilder(node.getUrl()).append("/databases/").append(node.getDatabase()).append("/queries?queryHash=").append(this._indexQuery.getQueryHash());
        if (this._metadataOnly) {
            path.append("&metadataOnly=true");
        }
        if (this._indexEntriesOnly) {
            path.append("&debug=entries");
        }
        HttpPost request = new HttpPost();
        request.setEntity((HttpEntity)new ContentProviderHttpEntity(outputStream -> {
            try (JsonGenerator generator = this.mapper.getFactory().createGenerator(outputStream);){
                JsonExtensions.writeIndexQuery(generator, this._conventions, this._indexQuery);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, ContentType.APPLICATION_JSON));
        url.value = path.toString();
        return request;
    }

    @Override
    public void setResponse(String response, boolean fromCache) throws IOException {
        if (response == null) {
            this.result = null;
            return;
        }
        this.result = this.mapper.readValue(response, QueryResult.class);
        if (fromCache) {
            ((QueryResult)this.result).setDurationInMs(-1L);
        }
    }

    @Override
    public boolean isReadRequest() {
        return true;
    }
}

