/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.commands.batches;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.List;
import net.ravendb.client.documents.commands.batches.BatchOptions;
import net.ravendb.client.documents.commands.batches.ICommandData;
import net.ravendb.client.documents.conventions.DocumentConventions;
import net.ravendb.client.http.RavenCommand;
import net.ravendb.client.http.ServerNode;
import net.ravendb.client.json.ContentProviderHttpEntity;
import net.ravendb.client.json.JsonArrayResult;
import net.ravendb.client.primitives.CleanCloseable;
import net.ravendb.client.primitives.Reference;
import net.ravendb.client.util.TimeUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;

public class BatchCommand
extends RavenCommand<JsonArrayResult>
implements CleanCloseable {
    private final List<ICommandData> _commands;
    private final BatchOptions _options;

    public BatchCommand(DocumentConventions conventions, List<ICommandData> commands) {
        this(conventions, commands, null);
    }

    public BatchCommand(DocumentConventions conventions, List<ICommandData> commands, BatchOptions options) {
        super(JsonArrayResult.class);
        this._commands = commands;
        this._options = options;
        if (conventions == null) {
            throw new IllegalArgumentException("conventions cannot be null");
        }
        if (commands == null) {
            throw new IllegalArgumentException("commands cannot be null");
        }
    }

    @Override
    public HttpRequestBase createRequest(ServerNode node, Reference<String> url) {
        HttpPost request = new HttpPost();
        request.setEntity((HttpEntity)new ContentProviderHttpEntity(outputStream -> {
            try (JsonGenerator generator = this.mapper.getFactory().createGenerator(outputStream);){
                generator.writeStartObject();
                generator.writeFieldName("Commands");
                generator.writeStartArray();
                for (ICommandData command : this._commands) {
                    command.serialize(generator, this.mapper.getSerializerProviderInstance());
                }
                generator.writeEndArray();
                generator.writeEndObject();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, ContentType.APPLICATION_JSON));
        StringBuilder sb = new StringBuilder(node.getUrl() + "/databases/" + node.getDatabase() + "/bulk_docs");
        this.appendOptions(sb);
        url.value = sb.toString();
        return request;
    }

    @Override
    public void setResponse(String response, boolean fromCache) throws IOException {
        if (response == null) {
            throw new IllegalStateException("Got null response from the server after doing a batch, something is very wrong. Probably a garbled response.");
        }
        this.result = this.mapper.readValue(response, JsonArrayResult.class);
    }

    private void appendOptions(StringBuilder sb) {
        if (this._options == null) {
            return;
        }
        sb.append("?");
        if (this._options.isWaitForReplicas()) {
            sb.append("&waitForReplicasTimeout=").append(TimeUtils.durationToTimeSpan(this._options.getWaitForIndexesTimeout()));
            if (this._options.isThrowOnTimeoutInWaitForReplicas()) {
                sb.append("&throwOnTimeoutInWaitForReplicas=true");
            }
            sb.append("&numberOfReplicasToWaitFor=");
            sb.append(this._options.isMajority() ? "majority" : Integer.valueOf(this._options.getNumberOfReplicasToWaitFor()));
        }
        if (this._options.isWaitForIndexes()) {
            sb.append("&waitForIndexesTimeout=").append(TimeUtils.durationToTimeSpan(this._options.getWaitForIndexesTimeout()));
            if (this._options.isThrowOnTimeoutInWaitForIndexes()) {
                sb.append("&waitForIndexThrow=true");
            }
            if (this._options.getWaitForSpecificIndexes() != null) {
                for (String specificIndex : this._options.getWaitForSpecificIndexes()) {
                    sb.append("&waitForSpecificIndex=").append(specificIndex);
                }
            }
        }
    }

    @Override
    public boolean isReadRequest() {
        return false;
    }

    @Override
    public void close() {
    }
}

