/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.commands.batches;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import net.ravendb.client.documents.commands.batches.CommandType;
import net.ravendb.client.documents.commands.batches.ICommandData;

public class PutCommandDataBase<T extends JsonNode>
implements ICommandData {
    private String id;
    private final String name;
    private String changeVector;
    private T document;
    private final CommandType type = CommandType.PUT;

    protected PutCommandDataBase(String id, String changeVector, T document) {
        this.name = null;
        if (document == null) {
            throw new IllegalArgumentException("Document cannot be null");
        }
        this.id = id;
        this.changeVector = changeVector;
        this.document = document;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getChangeVector() {
        return this.changeVector;
    }

    public T getDocument() {
        return this.document;
    }

    @Override
    public CommandType getType() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, SerializerProvider serializerProvider) throws IOException {
        generator.writeStartObject();
        generator.writeStringField("Id", this.id);
        generator.writeStringField("ChangeVector", this.changeVector);
        generator.writeFieldName("Document");
        this.document.serialize(generator, serializerProvider);
        generator.writeStringField("Type", this.type.toString());
        generator.writeEndObject();
    }
}

