/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.conventions;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.ravendb.client.exceptions.RavenException;
import net.ravendb.client.extensions.JsonExtensions;
import net.ravendb.client.http.ReadBalanceBehavior;
import net.ravendb.client.primitives.Tuple;
import net.ravendb.client.serverwide.ClientConfiguration;
import net.ravendb.client.util.Inflector;
import net.ravendb.client.util.ReflectionUtil;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.ObjectUtils;

public class DocumentConventions {
    public static final DocumentConventions defaultConventions = new DocumentConventions();
    private static final Map<Class, String> _cachedDefaultTypeCollectionNames = new HashMap<Class, String>();
    private final List<Tuple<Class, BiFunction<String, Object, String>>> _listOfRegisteredIdConventions = new ArrayList<Tuple<Class, BiFunction<String, Object, String>>>();
    private boolean _frozen;
    private ClientConfiguration _originalConfiguration;
    private final Map<Class, Field> _idPropertyCache = new HashMap<Class, Field>();
    private boolean _saveEnumsAsIntegers;
    private String _identityPartsSeparator = "/";
    private boolean _disableTopologyUpdates;
    private Function<PropertyDescriptor, Boolean> _findIdentityProperty;
    private Function<String, String> _transformClassCollectionNameToDocumentIdPrefix;
    private BiFunction<String, Object, String> _documentIdGenerator;
    private Function<String, String> _findIdentityPropertyNameFromEntityName;
    private Function<Class, String> _findCollectionName;
    private Function<Class, String> _findJavaClassName;
    private BiFunction<String, ObjectNode, String> _findJavaClass;
    private boolean _useOptimisticConcurrency;
    private boolean _throwIfQueryPageSizeIsNotSet;
    private int _maxNumberOfRequestsPerSession = 30;
    private ReadBalanceBehavior _readBalanceBehavior = ReadBalanceBehavior.NONE;
    private int _maxHttpCacheSize = 0x8000000;
    private ObjectMapper _entityMapper;

    public DocumentConventions() {
        this._findIdentityProperty = q -> q.getName().equals("id");
        this._findIdentityPropertyNameFromEntityName = entityName -> "Id";
        this._findJavaClass = (id, doc) -> {
            TextNode javaType;
            JsonNode metadata = doc.get("@metadata");
            if (metadata != null && (javaType = (TextNode)metadata.get("Raven-Java-Type")) != null) {
                return javaType.asText();
            }
            return null;
        };
        this._findJavaClassName = type -> ReflectionUtil.getFullNameWithoutVersionInformation(type);
        this._transformClassCollectionNameToDocumentIdPrefix = collectionName -> DocumentConventions.defaultTransformCollectionNameToDocumentIdPrefix(collectionName);
        this._findCollectionName = type -> DocumentConventions.defaultGetCollectionName(type);
        this._entityMapper = JsonExtensions.getDefaultEntityMapper();
    }

    public ObjectMapper getEntityMapper() {
        return this._entityMapper;
    }

    public void setEntityMapper(ObjectMapper entityMapper) {
        this._entityMapper = entityMapper;
    }

    public ReadBalanceBehavior getReadBalanceBehavior() {
        return this._readBalanceBehavior;
    }

    public void setReadBalanceBehavior(ReadBalanceBehavior _readBalanceBehavior) {
        this._readBalanceBehavior = _readBalanceBehavior;
    }

    public Object deserializeEntityFromJson(Class documentType, ObjectNode document) {
        try {
            return JsonExtensions.getDefaultMapper().treeToValue((TreeNode)document, documentType);
        }
        catch (JsonProcessingException e) {
            throw new RavenException("Cannot deserialize entity", e);
        }
    }

    public int getMaxHttpCacheSize() {
        return this._maxHttpCacheSize;
    }

    public void setMaxHttpCacheSize(int maxHttpCacheSize) {
        this._maxHttpCacheSize = maxHttpCacheSize;
    }

    public int getMaxNumberOfRequestsPerSession() {
        return this._maxNumberOfRequestsPerSession;
    }

    public void setMaxNumberOfRequestsPerSession(int _maxNumberOfRequestsPerSession) {
        this._maxNumberOfRequestsPerSession = _maxNumberOfRequestsPerSession;
    }

    public boolean isThrowIfQueryPageSizeIsNotSet() {
        return this._throwIfQueryPageSizeIsNotSet;
    }

    public void setThrowIfQueryPageSizeIsNotSet(boolean throwIfQueryPageSizeIsNotSet) {
        this.assertNotFrozen();
        this._throwIfQueryPageSizeIsNotSet = throwIfQueryPageSizeIsNotSet;
    }

    public boolean isUseOptimisticConcurrency() {
        return this._useOptimisticConcurrency;
    }

    public void setUseOptimisticConcurrency(boolean useOptimisticConcurrency) {
        this._useOptimisticConcurrency = useOptimisticConcurrency;
    }

    public BiFunction<String, ObjectNode, String> getFindJavaClass() {
        return this._findJavaClass;
    }

    public void setFindJavaClass(BiFunction<String, ObjectNode, String> _findJavaClass) {
        this.assertNotFrozen();
        this._findJavaClass = _findJavaClass;
    }

    public Function<Class, String> getFindJavaClassName() {
        return this._findJavaClassName;
    }

    public void setFindJavaClassName(Function<Class, String> _findJavaClassName) {
        this.assertNotFrozen();
        this._findJavaClassName = _findJavaClassName;
    }

    public Function<Class, String> getFindCollectionName() {
        return this._findCollectionName;
    }

    public void setFindCollectionName(Function<Class, String> _findCollectionName) {
        this.assertNotFrozen();
        this._findCollectionName = _findCollectionName;
    }

    public Function<String, String> getFindIdentityPropertyNameFromEntityName() {
        return this._findIdentityPropertyNameFromEntityName;
    }

    public void setFindIdentityPropertyNameFromEntityName(Function<String, String> findIdentityPropertyNameFromEntityName) {
        this.assertNotFrozen();
        this._findIdentityPropertyNameFromEntityName = findIdentityPropertyNameFromEntityName;
    }

    public BiFunction<String, Object, String> getDocumentIdGenerator() {
        return this._documentIdGenerator;
    }

    public void setDocumentIdGenerator(BiFunction<String, Object, String> _documentIdGenerator) {
        this.assertNotFrozen();
        this._documentIdGenerator = _documentIdGenerator;
    }

    public Function<String, String> getTransformClassCollectionNameToDocumentIdPrefix() {
        return this._transformClassCollectionNameToDocumentIdPrefix;
    }

    public void setTransformClassCollectionNameToDocumentIdPrefix(Function<String, String> transformClassCollectionNameToDocumentIdPrefix) {
        this.assertNotFrozen();
        this._transformClassCollectionNameToDocumentIdPrefix = transformClassCollectionNameToDocumentIdPrefix;
    }

    public Function<PropertyDescriptor, Boolean> getFindIdentityProperty() {
        return this._findIdentityProperty;
    }

    public void setFindIdentityProperty(Function<PropertyDescriptor, Boolean> findIdentityProperty) {
        this._findIdentityProperty = findIdentityProperty;
    }

    public boolean isDisableTopologyUpdates() {
        return this._disableTopologyUpdates;
    }

    public void setDisableTopologyUpdates(boolean _disableTopologyUpdates) {
        this.assertNotFrozen();
        this._disableTopologyUpdates = _disableTopologyUpdates;
    }

    public String getIdentityPartsSeparator() {
        return this._identityPartsSeparator;
    }

    public void setIdentityPartsSeparator(String _identityPartsSeparator) {
        this._identityPartsSeparator = _identityPartsSeparator;
    }

    public boolean isSaveEnumsAsIntegers() {
        return this._saveEnumsAsIntegers;
    }

    public void setSaveEnumsAsIntegers(boolean saveEnumsAsIntegers) {
        this.assertNotFrozen();
        this._saveEnumsAsIntegers = saveEnumsAsIntegers;
    }

    public static String defaultGetCollectionName(Class clazz) {
        String result = _cachedDefaultTypeCollectionNames.get(clazz);
        if (result != null) {
            return result;
        }
        result = Inflector.pluralize(clazz.getSimpleName());
        _cachedDefaultTypeCollectionNames.put(clazz, result);
        return result;
    }

    public String getCollectionName(Class clazz) {
        String collectionName = this._findCollectionName.apply(clazz);
        if (collectionName != null) {
            return collectionName;
        }
        return DocumentConventions.defaultGetCollectionName(clazz);
    }

    public String getCollectionName(Object entity) {
        if (entity == null) {
            return null;
        }
        return this.getCollectionName(entity.getClass());
    }

    public String generateDocumentId(String databaseName, Object entity) {
        Class<?> clazz = entity.getClass();
        for (Tuple<Class, BiFunction<String, Object, String>> listOfRegisteredIdConvention : this._listOfRegisteredIdConventions) {
            if (!((Class)listOfRegisteredIdConvention.first).isAssignableFrom(clazz)) continue;
            return (String)((BiFunction)listOfRegisteredIdConvention.second).apply(databaseName, entity);
        }
        return this._documentIdGenerator.apply(databaseName, entity);
    }

    public <TEntity> DocumentConventions registerIdConvention(Class<TEntity> clazz, BiFunction<String, TEntity, String> function) {
        int index;
        this.assertNotFrozen();
        this._listOfRegisteredIdConventions.stream().filter(x -> ((Class)x.first).equals(clazz)).findFirst().ifPresent(x -> this._listOfRegisteredIdConventions.remove(x));
        for (index = 0; index < this._listOfRegisteredIdConventions.size(); ++index) {
            Tuple<Class, BiFunction<String, Object, String>> entry = this._listOfRegisteredIdConventions.get(index);
            if (((Class)entry.first).isAssignableFrom(clazz)) break;
        }
        this._listOfRegisteredIdConventions.add(index, Tuple.create(clazz, function));
        return this;
    }

    public String getJavaClass(String id, ObjectNode document) {
        return this._findJavaClass.apply(id, document);
    }

    public String getJavaClassName(Class entityType) {
        return this._findJavaClassName.apply(entityType);
    }

    public DocumentConventions clone() {
        DocumentConventions cloned = new DocumentConventions();
        try {
            BeanUtils.copyProperties((Object)cloned, (Object)this);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return cloned;
    }

    private static Field getField(Class<?> clazz, String name) {
        Field field = null;
        while (clazz != null && field == null) {
            try {
                field = clazz.getDeclaredField(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
            clazz = clazz.getSuperclass();
        }
        return field;
    }

    public Field getIdentityProperty(Class clazz) {
        Field info = this._idPropertyCache.get(clazz);
        if (info != null) {
            return info;
        }
        try {
            Field idField = Arrays.stream(Introspector.getBeanInfo(clazz).getPropertyDescriptors()).filter(x -> this._findIdentityProperty.apply((PropertyDescriptor)x)).findFirst().map(x -> DocumentConventions.getField(clazz, x.getName())).orElse(null);
            this._idPropertyCache.put(clazz, idField);
            return idField;
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFrom(ClientConfiguration configuration) {
        if (configuration == null) {
            return;
        }
        DocumentConventions documentConventions = this;
        synchronized (documentConventions) {
            if (configuration.isDisabled() && this._originalConfiguration == null) {
                return;
            }
            if (configuration.isDisabled() && this._originalConfiguration != null) {
                this._maxNumberOfRequestsPerSession = this._originalConfiguration.getMaxNumberOfRequestsPerSession();
                this._readBalanceBehavior = this._originalConfiguration.getReadBalanceBehavior();
                this._originalConfiguration = null;
                return;
            }
            if (this._originalConfiguration == null) {
                this._originalConfiguration = new ClientConfiguration();
                this._originalConfiguration.setEtag(-1L);
                this._originalConfiguration.setMaxNumberOfRequestsPerSession(this._maxNumberOfRequestsPerSession);
                this._originalConfiguration.setReadBalanceBehavior(this._readBalanceBehavior);
            }
            this._maxNumberOfRequestsPerSession = (Integer)ObjectUtils.firstNonNull((Object[])new Integer[]{configuration.getMaxNumberOfRequestsPerSession(), this._originalConfiguration.getMaxNumberOfRequestsPerSession()});
            this._readBalanceBehavior = (ReadBalanceBehavior)((Object)ObjectUtils.firstNonNull((Object[])new ReadBalanceBehavior[]{configuration.getReadBalanceBehavior(), this._originalConfiguration.getReadBalanceBehavior()}));
        }
    }

    public static String defaultTransformCollectionNameToDocumentIdPrefix(String collectionName) {
        long upperCount = collectionName.chars().filter(x -> Character.isUpperCase(x)).count();
        if (upperCount <= 1L) {
            return collectionName.toLowerCase();
        }
        return collectionName;
    }

    public void freeze() {
        this._frozen = true;
    }

    private void assertNotFrozen() {
        if (this._frozen) {
            throw new IllegalStateException("Conventions has been frozen after documentStore.initialize() and no changes can be applied to them");
        }
    }
}

