/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.identity;

import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import net.ravendb.client.documents.IDocumentStore;
import net.ravendb.client.documents.commands.HiLoReturnCommand;
import net.ravendb.client.documents.commands.NextHiLoCommand;
import net.ravendb.client.documents.identity.HiLoResult;
import net.ravendb.client.http.RequestExecutor;

public class HiLoIdGenerator {
    private final Object generatorLock = new Object();
    private final IDocumentStore _store;
    private final String _tag;
    protected String prefix;
    private long _lastBatchSize;
    private Date _lastRangeDate;
    private final String _dbName;
    private final String _identityPartsSeparator;
    private volatile RangeValue _range;
    protected String serverTag;

    public HiLoIdGenerator(String tag, IDocumentStore store, String dbName, String identityPartsSeparator) {
        this._store = store;
        this._tag = tag;
        this._dbName = dbName;
        this._identityPartsSeparator = identityPartsSeparator;
        this._range = new RangeValue(1L, 0L);
    }

    protected String getDocumentIdFromId(long nextId) {
        return this.prefix + nextId + "-" + this.serverTag;
    }

    public RangeValue getRange() {
        return this._range;
    }

    public void setRange(RangeValue _range) {
        this._range = _range;
    }

    public String generateDocumentId(Object entity) {
        return this.getDocumentIdFromId(this.nextId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long nextId() {
        while (true) {
            RangeValue range = this._range;
            long id = range.Current.incrementAndGet();
            if (id <= range.Max) {
                return id;
            }
            Object object = this.generatorLock;
            synchronized (object) {
                id = range.Current.get();
                if (id <= range.Max) {
                    return id;
                }
                this.getNextRange();
            }
        }
    }

    private void getNextRange() {
        NextHiLoCommand hiloCommand = new NextHiLoCommand(this._tag, this._lastBatchSize, this._lastRangeDate, this._identityPartsSeparator, this._range.Max);
        RequestExecutor re = this._store.getRequestExecutor();
        re.execute(hiloCommand);
        this.prefix = ((HiLoResult)hiloCommand.getResult()).getPrefix();
        this.serverTag = ((HiLoResult)hiloCommand.getResult()).getServerTag();
        this._lastRangeDate = ((HiLoResult)hiloCommand.getResult()).getLastRangeAt();
        this._lastBatchSize = ((HiLoResult)hiloCommand.getResult()).getLastSize();
        this._range = new RangeValue(((HiLoResult)hiloCommand.getResult()).getLow(), ((HiLoResult)hiloCommand.getResult()).getHigh());
    }

    public void returnUnusedRange() {
        HiLoReturnCommand returnCommand = new HiLoReturnCommand(this._tag, this._range.Current.get(), this._range.Max);
        RequestExecutor re = this._store.getRequestExecutor(this._dbName);
        re.execute(returnCommand);
    }

    protected class RangeValue {
        public final long Min;
        public final long Max;
        public final AtomicLong Current;

        public RangeValue(long min, long max) {
            this.Min = min;
            this.Max = max;
            this.Current = new AtomicLong(min - 1L);
        }
    }
}

