/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.indexes;

import java.util.Collection;
import net.ravendb.client.documents.IDocumentStore;
import net.ravendb.client.documents.conventions.DocumentConventions;
import net.ravendb.client.documents.indexes.AbstractIndexCreationTask;
import net.ravendb.client.documents.indexes.IndexDefinition;
import net.ravendb.client.documents.indexes.IndexPriority;
import net.ravendb.client.documents.operations.indexes.PutIndexesOperation;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IndexCreation {
    private static final Log logger = LogFactory.getLog(IndexCreation.class);

    public static void createIndexes(Collection<AbstractIndexCreationTask> indexes, IDocumentStore store) {
        IndexCreation.createIndexes(indexes, store, null);
    }

    public static void createIndexes(Collection<AbstractIndexCreationTask> indexes, IDocumentStore store, DocumentConventions conventions) {
        if (conventions == null) {
            conventions = store.getConventions();
        }
        try {
            IndexDefinition[] indexesToAdd = IndexCreation.createIndexesToAdd(indexes, conventions);
            store.maintenance().send(new PutIndexesOperation(indexesToAdd));
        }
        catch (Exception e) {
            logger.info((Object)"Could not create indexes in one shot (maybe using older version of RavenDB ?)", (Throwable)e);
            for (AbstractIndexCreationTask index : indexes) {
                index.execute(store, conventions);
            }
        }
    }

    public static IndexDefinition[] createIndexesToAdd(Collection<AbstractIndexCreationTask> indexCreationTasks, DocumentConventions conventions) {
        return (IndexDefinition[])indexCreationTasks.stream().map(x -> {
            x.setConventions(conventions);
            IndexDefinition definition = x.createIndexDefinition();
            definition.setName(x.getIndexName());
            definition.setPriority((IndexPriority)((Object)((Object)ObjectUtils.firstNonNull((Object[])new IndexPriority[]{x.getPriority(), IndexPriority.NORMAL}))));
            return definition;
        }).toArray(IndexDefinition[]::new);
    }
}

