/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.indexes;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.ravendb.client.documents.indexes.IndexConfiguration;
import net.ravendb.client.documents.indexes.IndexFieldOptions;
import net.ravendb.client.documents.indexes.IndexLockMode;
import net.ravendb.client.documents.indexes.IndexPriority;
import net.ravendb.client.documents.indexes.IndexType;
import org.apache.commons.lang3.StringUtils;

public class IndexDefinition {
    private String name;
    private IndexPriority priority;
    private IndexLockMode lockMode;
    private Map<String, String> additionalSources;
    private Set<String> maps;
    private String reduce;
    private Map<String, IndexFieldOptions> fields;
    private IndexConfiguration configuration = new IndexConfiguration();
    private IndexType indexType;
    private String outputReduceToCollection;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IndexPriority getPriority() {
        return this.priority;
    }

    public void setPriority(IndexPriority priority) {
        this.priority = priority;
    }

    public IndexLockMode getLockMode() {
        return this.lockMode;
    }

    public void setLockMode(IndexLockMode lockMode) {
        this.lockMode = lockMode;
    }

    public Map<String, String> getAdditionalSources() {
        if (this.additionalSources == null) {
            this.additionalSources = new HashMap<String, String>();
        }
        return this.additionalSources;
    }

    public void setAdditionalSources(Map<String, String> additionalSources) {
        this.additionalSources = additionalSources;
    }

    public Set<String> getMaps() {
        if (this.maps == null) {
            this.maps = new HashSet<String>();
        }
        return this.maps;
    }

    public void setMaps(Set<String> maps) {
        this.maps = maps;
    }

    public String getReduce() {
        return this.reduce;
    }

    public void setReduce(String reduce) {
        this.reduce = reduce;
    }

    public String toString() {
        return this.name;
    }

    public Map<String, IndexFieldOptions> getFields() {
        if (this.fields == null) {
            this.fields = new HashMap<String, IndexFieldOptions>();
        }
        return this.fields;
    }

    public void setFields(Map<String, IndexFieldOptions> fields) {
        this.fields = fields;
    }

    public IndexConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new IndexConfiguration();
        }
        return this.configuration;
    }

    public void setConfiguration(IndexConfiguration configuration) {
        this.configuration = configuration;
    }

    public IndexType getType() {
        if (this.indexType == null || this.indexType == IndexType.NONE) {
            this.indexType = this.detectStaticIndexType();
        }
        return this.indexType;
    }

    public void setType(IndexType indexType) {
        this.indexType = indexType;
    }

    private IndexType detectStaticIndexType() {
        if (this.reduce == null || StringUtils.isBlank((CharSequence)this.reduce)) {
            return IndexType.MAP;
        }
        return IndexType.MAP_REDUCE;
    }

    public String getOutputReduceToCollection() {
        return this.outputReduceToCollection;
    }

    public void setOutputReduceToCollection(String outputReduceToCollection) {
        this.outputReduceToCollection = outputReduceToCollection;
    }
}

