/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.indexes;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import net.ravendb.client.documents.conventions.DocumentConventions;
import net.ravendb.client.documents.indexes.FieldIndexing;
import net.ravendb.client.documents.indexes.FieldStorage;
import net.ravendb.client.documents.indexes.FieldTermVector;
import net.ravendb.client.documents.indexes.IndexDefinition;
import net.ravendb.client.documents.indexes.IndexFieldOptions;
import net.ravendb.client.documents.indexes.IndexLockMode;
import net.ravendb.client.documents.indexes.IndexPriority;
import net.ravendb.client.documents.indexes.spatial.SpatialOptions;
import net.ravendb.client.exceptions.documents.compilation.IndexCompilationException;
import org.apache.commons.lang3.ObjectUtils;

public class IndexDefinitionBuilder {
    private final String _indexName;
    private String map;
    private String reduce;
    private Map<String, FieldStorage> storesStrings;
    private Map<String, FieldIndexing> indexesStrings;
    private Map<String, String> analyzersStrings;
    private Set<String> suggestionsOptions;
    private Map<String, FieldTermVector> termVectorsStrings;
    private Map<String, SpatialOptions> spatialIndexesStrings;
    private IndexLockMode lockMode;
    private IndexPriority priority;
    private String outputReduceToCollection;
    private Map<String, String> additionalSources;

    public IndexDefinitionBuilder() {
        this(null);
    }

    public IndexDefinitionBuilder(String indexName) {
        this._indexName = (String)ObjectUtils.firstNonNull((Object[])new String[]{indexName, this.getClass().getSimpleName()});
        this.storesStrings = new HashMap<String, FieldStorage>();
        this.indexesStrings = new HashMap<String, FieldIndexing>();
        this.suggestionsOptions = new HashSet<String>();
        this.analyzersStrings = new HashMap<String, String>();
        this.termVectorsStrings = new HashMap<String, FieldTermVector>();
        this.spatialIndexesStrings = new HashMap<String, SpatialOptions>();
    }

    public IndexDefinition toIndexDefinition(DocumentConventions conventions) {
        return this.toIndexDefinition(conventions, true);
    }

    public IndexDefinition toIndexDefinition(DocumentConventions conventions, boolean validateMap) {
        if (this.map == null && validateMap) {
            throw new IllegalStateException("Map is required to generate an index, you cannot create an index without a valid Map property (in index " + this._indexName + ").");
        }
        try {
            IndexDefinition indexDefinition = new IndexDefinition();
            indexDefinition.setName(this._indexName);
            indexDefinition.setReduce(this.reduce);
            indexDefinition.setLockMode(this.lockMode);
            indexDefinition.setPriority(this.priority);
            indexDefinition.setOutputReduceToCollection(this.outputReduceToCollection);
            HashMap<String, Boolean> suggestions = new HashMap<String, Boolean>();
            for (String suggestionsOption : this.suggestionsOptions) {
                suggestions.put(suggestionsOption, true);
            }
            this.applyValues(indexDefinition, this.indexesStrings, (options, value) -> options.setIndexing((FieldIndexing)((Object)value)));
            this.applyValues(indexDefinition, this.storesStrings, (options, value) -> options.setStorage((FieldStorage)((Object)value)));
            this.applyValues(indexDefinition, this.analyzersStrings, (options, value) -> options.setAnalyzer((String)value));
            this.applyValues(indexDefinition, this.termVectorsStrings, (options, value) -> options.setTermVector((FieldTermVector)((Object)value)));
            this.applyValues(indexDefinition, this.spatialIndexesStrings, (options, value) -> options.setSpatial((SpatialOptions)value));
            this.applyValues(indexDefinition, suggestions, (options, value) -> options.setSuggestions((boolean)value));
            if (this.map != null) {
                indexDefinition.getMaps().add(this.map);
            }
            indexDefinition.setAdditionalSources(this.additionalSources);
            return indexDefinition;
        }
        catch (Exception e) {
            throw new IndexCompilationException("Failed to create index " + this._indexName, e);
        }
    }

    private <T> void applyValues(IndexDefinition indexDefinition, Map<String, T> values, BiConsumer<IndexFieldOptions, T> action) {
        for (Map.Entry<String, T> kvp : values.entrySet()) {
            IndexFieldOptions field = indexDefinition.getFields().computeIfAbsent(kvp.getKey(), x -> new IndexFieldOptions());
            action.accept(field, (IndexFieldOptions)kvp.getValue());
        }
    }

    public String getMap() {
        return this.map;
    }

    public void setMap(String map) {
        this.map = map;
    }

    public String getReduce() {
        return this.reduce;
    }

    public void setReduce(String reduce) {
        this.reduce = reduce;
    }

    public Map<String, FieldStorage> getStoresStrings() {
        return this.storesStrings;
    }

    public void setStoresStrings(Map<String, FieldStorage> storesStrings) {
        this.storesStrings = storesStrings;
    }

    public Map<String, FieldIndexing> getIndexesStrings() {
        return this.indexesStrings;
    }

    public void setIndexesStrings(Map<String, FieldIndexing> indexesStrings) {
        this.indexesStrings = indexesStrings;
    }

    public Map<String, String> getAnalyzersStrings() {
        return this.analyzersStrings;
    }

    public void setAnalyzersStrings(Map<String, String> analyzersStrings) {
        this.analyzersStrings = analyzersStrings;
    }

    public Set<String> getSuggestionsOptions() {
        return this.suggestionsOptions;
    }

    public void setSuggestionsOptions(Set<String> suggestionsOptions) {
        this.suggestionsOptions = suggestionsOptions;
    }

    public Map<String, FieldTermVector> getTermVectorsStrings() {
        return this.termVectorsStrings;
    }

    public void setTermVectorsStrings(Map<String, FieldTermVector> termVectorsStrings) {
        this.termVectorsStrings = termVectorsStrings;
    }

    public Map<String, SpatialOptions> getSpatialIndexesStrings() {
        return this.spatialIndexesStrings;
    }

    public void setSpatialIndexesStrings(Map<String, SpatialOptions> spatialIndexesStrings) {
        this.spatialIndexesStrings = spatialIndexesStrings;
    }

    public IndexLockMode getLockMode() {
        return this.lockMode;
    }

    public void setLockMode(IndexLockMode lockMode) {
        this.lockMode = lockMode;
    }

    public IndexPriority getPriority() {
        return this.priority;
    }

    public void setPriority(IndexPriority priority) {
        this.priority = priority;
    }

    public String getOutputReduceToCollection() {
        return this.outputReduceToCollection;
    }

    public void setOutputReduceToCollection(String outputReduceToCollection) {
        this.outputReduceToCollection = outputReduceToCollection;
    }

    public Map<String, String> getAdditionalSources() {
        return this.additionalSources;
    }

    public void setAdditionalSources(Map<String, String> additionalSources) {
        this.additionalSources = additionalSources;
    }
}

