/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.operations;

import net.ravendb.client.documents.DocumentStoreBase;
import net.ravendb.client.documents.operations.IMaintenanceOperation;
import net.ravendb.client.documents.operations.IVoidMaintenanceOperation;
import net.ravendb.client.documents.operations.Operation;
import net.ravendb.client.documents.operations.OperationIdResult;
import net.ravendb.client.http.RavenCommand;
import net.ravendb.client.http.RequestExecutor;
import net.ravendb.client.http.VoidRavenCommand;
import net.ravendb.client.serverwide.operations.ServerOperationExecutor;
import org.apache.commons.lang3.StringUtils;

public class MaintenanceOperationExecutor {
    private final DocumentStoreBase store;
    private final String databaseName;
    private final RequestExecutor requestExecutor;
    private ServerOperationExecutor serverOperationExecutor;

    public MaintenanceOperationExecutor(DocumentStoreBase store) {
        this(store, null);
    }

    public MaintenanceOperationExecutor(DocumentStoreBase store, String databaseName) {
        this.store = store;
        this.databaseName = databaseName;
        this.requestExecutor = store.getRequestExecutor(databaseName);
    }

    public ServerOperationExecutor server() {
        if (this.serverOperationExecutor != null) {
            return this.serverOperationExecutor;
        }
        this.serverOperationExecutor = new ServerOperationExecutor(this.store);
        return this.serverOperationExecutor;
    }

    public MaintenanceOperationExecutor forDatabase(String databaseName) {
        if (StringUtils.equalsIgnoreCase((CharSequence)this.databaseName, (CharSequence)databaseName)) {
            return this;
        }
        return new MaintenanceOperationExecutor(this.store, databaseName);
    }

    public void send(IVoidMaintenanceOperation operation) {
        VoidRavenCommand command = operation.getCommand(this.requestExecutor.getConventions());
        this.requestExecutor.execute(command);
    }

    public <TResult> TResult send(IMaintenanceOperation<TResult> operation) {
        RavenCommand<TResult> command = operation.getCommand(this.requestExecutor.getConventions());
        this.requestExecutor.execute(command);
        return command.getResult();
    }

    public Operation sendAsync(IMaintenanceOperation<OperationIdResult> operation) {
        RavenCommand<OperationIdResult> command = operation.getCommand(this.requestExecutor.getConventions());
        this.requestExecutor.execute(command);
        return new Operation(this.requestExecutor, this.requestExecutor.getConventions(), command.getResult().getOperationId());
    }
}

