/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.operations;

import net.ravendb.client.documents.DocumentStoreBase;
import net.ravendb.client.documents.operations.IOperation;
import net.ravendb.client.documents.operations.IVoidOperation;
import net.ravendb.client.documents.operations.Operation;
import net.ravendb.client.documents.operations.OperationIdResult;
import net.ravendb.client.documents.operations.PatchOperation;
import net.ravendb.client.documents.operations.PatchResult;
import net.ravendb.client.documents.operations.PatchStatus;
import net.ravendb.client.documents.session.SessionInfo;
import net.ravendb.client.http.RavenCommand;
import net.ravendb.client.http.RequestExecutor;
import net.ravendb.client.http.VoidRavenCommand;
import org.apache.commons.lang3.StringUtils;

public class OperationExecutor {
    private final DocumentStoreBase store;
    private final String databaseName;
    private final RequestExecutor requestExecutor;

    public OperationExecutor(DocumentStoreBase store) {
        this(store, null);
    }

    public OperationExecutor(DocumentStoreBase store, String databaseName) {
        this.store = store;
        this.databaseName = databaseName != null ? databaseName : store.getDatabase();
        this.requestExecutor = store.getRequestExecutor(databaseName);
    }

    public OperationExecutor forDatabase(String databaseName) {
        if (StringUtils.equalsIgnoreCase((CharSequence)this.databaseName, (CharSequence)databaseName)) {
            return this;
        }
        return new OperationExecutor(this.store, databaseName);
    }

    public void send(IVoidOperation operation) {
        this.send(operation, (SessionInfo)null);
    }

    public void send(IVoidOperation operation, SessionInfo sessionInfo) {
        VoidRavenCommand command = operation.getCommand(this.store, this.requestExecutor.getConventions(), this.requestExecutor.getCache());
        this.requestExecutor.execute(command, sessionInfo);
    }

    public <TResult> TResult send(IOperation<TResult> operation) {
        return this.send(operation, null);
    }

    public <TResult> TResult send(IOperation<TResult> operation, SessionInfo sessionInfo) {
        RavenCommand<TResult> command = operation.getCommand(this.store, this.requestExecutor.getConventions(), this.requestExecutor.getCache());
        this.requestExecutor.execute(command);
        return command.getResult();
    }

    public Operation sendAsync(IOperation<OperationIdResult> operation) {
        return this.sendAsync(operation, null);
    }

    public Operation sendAsync(IOperation<OperationIdResult> operation, SessionInfo sessionInfo) {
        RavenCommand<OperationIdResult> command = operation.getCommand(this.store, this.requestExecutor.getConventions(), this.requestExecutor.getCache());
        this.requestExecutor.execute(command, sessionInfo);
        return new Operation(this.requestExecutor, this.requestExecutor.getConventions(), command.getResult().getOperationId());
    }

    public PatchStatus send(PatchOperation operation) {
        RavenCommand<PatchResult> command = operation.getCommand(this.store, this.requestExecutor.getConventions(), this.requestExecutor.getCache());
        this.requestExecutor.execute(command);
        if (command.getStatusCode() == 304) {
            return PatchStatus.NOT_MODIFIED;
        }
        if (command.getStatusCode() == 404) {
            return PatchStatus.DOCUMENT_DOES_NOT_EXIST;
        }
        return command.getResult().getStatus();
    }

    public <TEntity> PatchOperation.Result<TEntity> send(Class<TEntity> entityClass, PatchOperation operation) {
        RavenCommand<PatchResult> command = operation.getCommand(this.store, this.requestExecutor.getConventions(), this.requestExecutor.getCache());
        this.requestExecutor.execute(command);
        PatchOperation.Result<Object> result = new PatchOperation.Result<Object>();
        if (command.getStatusCode() == 304) {
            result.setStatus(PatchStatus.NOT_MODIFIED);
            return result;
        }
        if (command.getStatusCode() == 404) {
            result.setStatus(PatchStatus.DOCUMENT_DOES_NOT_EXIST);
            return result;
        }
        result.setStatus(command.getResult().getStatus());
        result.setDocument(this.requestExecutor.getConventions().deserializeEntityFromJson(entityClass, command.getResult().getModifiedDocument()));
        return result;
    }
}

