/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.operations;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import net.ravendb.client.documents.IDocumentStore;
import net.ravendb.client.documents.conventions.DocumentConventions;
import net.ravendb.client.documents.operations.IOperation;
import net.ravendb.client.documents.operations.PatchRequest;
import net.ravendb.client.documents.operations.PatchResult;
import net.ravendb.client.documents.operations.PatchStatus;
import net.ravendb.client.http.HttpCache;
import net.ravendb.client.http.RavenCommand;
import net.ravendb.client.http.ServerNode;
import net.ravendb.client.json.ContentProviderHttpEntity;
import net.ravendb.client.primitives.Reference;
import net.ravendb.client.util.UrlUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;

public class PatchOperation
implements IOperation<PatchResult> {
    private final String _id;
    private final String _changeVector;
    private final PatchRequest _patch;
    private final PatchRequest _patchIfMissing;
    private final boolean _skipPatchIfChangeVectorMismatch;

    public PatchOperation(String id, String changeVector, PatchRequest patch) {
        this(id, changeVector, patch, null, false);
    }

    public PatchOperation(String id, String changeVector, PatchRequest patch, PatchRequest patchIfMissing, boolean skipPatchIfChangeVectorMismatch) {
        if (patch == null) {
            throw new IllegalArgumentException("Patch cannot be null");
        }
        if (StringUtils.isWhitespace((CharSequence)patch.getScript())) {
            throw new IllegalArgumentException("Patch script cannot be null");
        }
        if (patchIfMissing != null && StringUtils.isWhitespace((CharSequence)patchIfMissing.getScript())) {
            throw new IllegalArgumentException("PatchIfMissing script cannot be null");
        }
        this._id = id;
        this._changeVector = changeVector;
        this._patch = patch;
        this._patchIfMissing = patchIfMissing;
        this._skipPatchIfChangeVectorMismatch = skipPatchIfChangeVectorMismatch;
    }

    @Override
    public RavenCommand<PatchResult> getCommand(IDocumentStore store, DocumentConventions conventions, HttpCache cache) {
        return new PatchCommand(conventions, this._id, this._changeVector, this._patch, this._patchIfMissing, this._skipPatchIfChangeVectorMismatch, false, false);
    }

    public static class PatchCommand
    extends RavenCommand<PatchResult> {
        private final String _id;
        private final String _changeVector;
        private final ObjectNode _patch;
        private final boolean _skipPatchIfChangeVectorMismatch;
        private final boolean _returnDebugInformation;
        private final boolean _test;

        public PatchCommand(DocumentConventions conventions, String id, String changeVector, PatchRequest patch, PatchRequest patchIfMissing, boolean skipPatchIfChangeVectorMismatch, boolean returnDebugInformation, boolean test) {
            super(PatchResult.class);
            if (conventions == null) {
                throw new IllegalArgumentException("Conventions cannot be null");
            }
            if (patch == null) {
                throw new IllegalArgumentException("Patch cannot be null");
            }
            if (StringUtils.isWhitespace((CharSequence)patch.getScript())) {
                throw new IllegalArgumentException("Patch.Script cannot be null");
            }
            if (patchIfMissing != null && StringUtils.isWhitespace((CharSequence)patchIfMissing.getScript())) {
                throw new IllegalArgumentException("PatchIfMissing.Script cannot be null");
            }
            if (id == null) {
                throw new IllegalArgumentException("Id cannot be null");
            }
            this._id = id;
            this._changeVector = changeVector;
            this._patch = (ObjectNode)this.mapper.valueToTree((Object)new Payload(patch, patchIfMissing));
            this._skipPatchIfChangeVectorMismatch = skipPatchIfChangeVectorMismatch;
            this._returnDebugInformation = returnDebugInformation;
            this._test = test;
        }

        @Override
        public boolean isReadRequest() {
            return false;
        }

        @Override
        public HttpRequestBase createRequest(ServerNode node, Reference<String> url) {
            url.value = node.getUrl() + "/databases/" + node.getDatabase() + "/docs?id=" + UrlUtils.escapeDataString(this._id);
            if (this._skipPatchIfChangeVectorMismatch) {
                url.value = url.value + "&skipPatchIfChangeVectorMismatch=true";
            }
            if (this._returnDebugInformation) {
                url.value = url.value + "&debug=true";
            }
            if (this._test) {
                url.value = url.value + "&test=true";
            }
            HttpPatch request = new HttpPatch();
            request.setEntity((HttpEntity)new ContentProviderHttpEntity(outputStream -> {
                try (JsonGenerator generator = this.mapper.getFactory().createGenerator(outputStream);){
                    generator.writeTree((TreeNode)this._patch);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }, ContentType.APPLICATION_JSON));
            this.addChangeVectorIfNotNull(this._changeVector, (HttpRequestBase)request);
            return request;
        }

        @Override
        public void setResponse(String response, boolean fromCache) throws IOException {
            if (response == null) {
                return;
            }
            this.result = this.mapper.readValue(response, this.resultClass);
        }
    }

    public static class Result<TEntity> {
        private PatchStatus status;
        private TEntity document;

        public PatchStatus getStatus() {
            return this.status;
        }

        public void setStatus(PatchStatus status) {
            this.status = status;
        }

        public TEntity getDocument() {
            return this.document;
        }

        public void setDocument(TEntity document) {
            this.document = document;
        }
    }

    public static class Payload {
        private final PatchRequest patch;
        private final PatchRequest patchIfMissing;

        public Payload(PatchRequest patch, PatchRequest patchIfMissing) {
            this.patch = patch;
            this.patchIfMissing = patchIfMissing;
        }

        public PatchRequest getPatch() {
            return this.patch;
        }

        public PatchRequest getPatchIfMissing() {
            return this.patchIfMissing;
        }
    }
}

