/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.operations;

import java.io.IOException;
import net.ravendb.client.documents.IDocumentStore;
import net.ravendb.client.documents.conventions.DocumentConventions;
import net.ravendb.client.documents.operations.CmpXchgResult;
import net.ravendb.client.documents.operations.IOperation;
import net.ravendb.client.http.HttpCache;
import net.ravendb.client.http.RavenCommand;
import net.ravendb.client.http.ServerNode;
import net.ravendb.client.primitives.Reference;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpRequestBase;

public class RemoveCompareExchangeOperation<T>
implements IOperation<CmpXchgResult<T>> {
    private final Class<T> _clazz;
    private final String _key;
    private final long _index;

    public RemoveCompareExchangeOperation(Class<T> clazz, String key, long index) {
        this._key = key;
        this._index = index;
        this._clazz = clazz;
    }

    @Override
    public RavenCommand<CmpXchgResult<T>> getCommand(IDocumentStore store, DocumentConventions conventions, HttpCache cache) {
        return new RemoveCompareExchangeCommand<T>(this._clazz, this._key, this._index);
    }

    private static class RemoveCompareExchangeCommand<T>
    extends RavenCommand<CmpXchgResult<T>> {
        private final Class<T> _clazz;
        private final String _key;
        private final long _index;

        public RemoveCompareExchangeCommand(Class<T> clazz, String key, long index) {
            super(CmpXchgResult.class);
            if (StringUtils.isEmpty((CharSequence)key)) {
                throw new IllegalArgumentException("The kye argument must have value");
            }
            this._clazz = clazz;
            this._key = key;
            this._index = index;
        }

        @Override
        public boolean isReadRequest() {
            return true;
        }

        @Override
        public HttpRequestBase createRequest(ServerNode node, Reference<String> url) {
            url.value = node.getUrl() + "/databases/" + node.getDatabase() + "/cmpxchg?key=" + this._key + "&index=" + this._index;
            return new HttpDelete();
        }

        @Override
        public void setResponse(String response, boolean fromCache) throws IOException {
            this.result = CmpXchgResult.parseFromString(this._clazz, response);
        }
    }
}

